/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Brand;
import com.jspgou.cms.entity.Category;
import com.jspgou.cms.entity.ProductType;
import com.jspgou.cms.entity.ProductTypeProperty;
import com.jspgou.cms.entity.StandardType;
import com.jspgou.cms.manager.BrandMng;
import com.jspgou.cms.manager.CategoryMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ProductTypeMng;
import com.jspgou.cms.manager.ProductTypePropertyMng;
import com.jspgou.cms.manager.StandardTypeMng;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.ServletContextAware;

@Controller
public class CategoryAct
implements ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(CategoryAct.class);
    @Autowired
    private BrandMng brandMng;
    @Autowired
    private ProductTypeMng productTypeMng;
    @Autowired
    private ProductTypePropertyMng productTypePropertyMng;
    @Autowired
    private StandardTypeMng standardTypeMng;
    @Autowired
    private CategoryMng manager;
    private ServletContext servletContext;
    @Autowired
    private ProductMng productMng;

    @RequestMapping(value={"/category/v_left.do"})
    public String left() {
        return "category/left";
    }

    @RequestMapping(value={"/category/v_tree.do"})
    public String tree(String root, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        List<Category> list;
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        log.debug("tree path={}", (Object)root);
        boolean isRoot = StringUtils.isBlank((String)root) || "source".equals(root);
        model.addAttribute("isRoot", (Object)isRoot);
        WebErrors errors = this.validateTree(root, request);
        if (errors.hasErrors()) {
            log.error((String)errors.getErrors().get(0));
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"[]");
            return null;
        }
        if (isRoot) {
            list = this.manager.getTopList(web.getId());
        } else {
            Long rootId = Long.valueOf(root);
            list = this.manager.getChildList(web.getId(), rootId);
        }
        model.addAttribute("list", list);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/json;charset=UTF-8");
        return "category/tree";
    }

    @RequestMapping(value={"/category/v_list.do"})
    public String list(Long root, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        List<Category> list = root == null ? this.manager.getTopList(web.getId()) : this.manager.getChildList(web.getId(), root);
        List<ProductType> typeList = this.productTypeMng.getList(web.getId());
        model.addAttribute("typeList", typeList);
        model.addAttribute("root", (Object)root);
        model.addAttribute("list", list);
        return "category/list";
    }

    @RequestMapping(value={"/category/v_add.do"})
    public String add(Long root, Long typeId, HttpServletRequest request, ModelMap model) {
        List<Brand> brandList;
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        Category parent = null;
        ProductType type = this.productTypeMng.findById(typeId);
        List<ProductTypeProperty> itemList = this.productTypePropertyMng.getList(typeId, true);
        if (root != null) {
            parent = this.manager.findById(root);
            model.addAttribute("parent", (Object)parent);
            model.addAttribute("root", (Object)root);
            brandList = new ArrayList<Brand>(parent.getBrands());
        } else {
            brandList = this.brandMng.getList();
        }
        model.addAttribute("brandList", brandList);
        String ctgTplDirRel = type.getCtgTplDirRel();
        String realDir = this.servletContext.getRealPath(ctgTplDirRel);
        String relPath = ctgTplDirRel.substring(web.getTemplateRel().length());
        String txtTplDirRel = type.getTxtTplDirRel();
        String txtrealDir = this.servletContext.getRealPath(txtTplDirRel);
        String txtrelPath = txtTplDirRel.substring(web.getTemplateRel().length());
        String[] channelTpls = type.getChannelTpls(realDir, relPath);
        String[] contentTpls = type.getContentTpls(txtrealDir, txtrelPath);
        List<Category> parentList = this.manager.getListForParent(SiteUtils.getWebId((HttpServletRequest)request), null);
        List<StandardType> standardTypeList = this.standardTypeMng.getList();
        model.addAttribute("standardTypeList", standardTypeList);
        model.addAttribute("channelTpls", (Object)channelTpls);
        model.addAttribute("contentTpls", (Object)contentTpls);
        model.addAttribute("parentList", parentList);
        model.addAttribute("type", (Object)type);
        model.addAttribute("itemList", itemList);
        return "category/add";
    }

    @RequestMapping(value={"/category/v_edit.do"})
    public String edit(Long id, Long root, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        if (root != null) {
            model.addAttribute("root", (Object)root);
        }
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        Category category = this.manager.findById(id);
        List<Category> parentList = this.manager.getListForParent(SiteUtils.getWebId((HttpServletRequest)request), id);
        List<ProductType> typeList = this.productTypeMng.getList(web.getId());
        ProductType type = category.getType();
        List<ProductTypeProperty> itemList = this.productTypePropertyMng.getList(type.getId(), true);
        List<Brand> brandList = category.getParent() != null ? new ArrayList<Brand>(category.getParent().getBrands()) : this.brandMng.getList();
        model.addAttribute("brandList", brandList);
        String ctgTplDirRel = type.getCtgTplDirRel();
        String realDir = this.servletContext.getRealPath(ctgTplDirRel);
        String relPath = ctgTplDirRel.substring(web.getTemplateRel().length());
        String txtTplDirRel = type.getTxtTplDirRel();
        String txtrealDir = this.servletContext.getRealPath(txtTplDirRel);
        String txtrelPath = txtTplDirRel.substring(web.getTemplateRel().length());
        Object[] channelTpls = type.getChannelTpls(realDir, relPath);
        Object[] contentTpls = type.getContentTpls(txtrealDir, txtrelPath);
        String tpl = category.getTplChannel();
        if (!StringUtils.isBlank((String)tpl) && !ArrayUtils.contains((Object[])channelTpls, (Object)tpl)) {
            channelTpls = (String[])ArrayUtils.add((Object[])channelTpls, (int)0, (Object)tpl);
        }
        if (!StringUtils.isBlank((String)(tpl = category.getTplContent())) && !ArrayUtils.contains((Object[])contentTpls, (Object)tpl)) {
            contentTpls = (String[])ArrayUtils.add((Object[])contentTpls, (int)0, (Object)tpl);
        }
        List<StandardType> standardTypeList = this.standardTypeMng.getList();
        Long[] standardTypeIds = StandardType.fetchIds(category.getStandardType());
        model.addAttribute("standardTypeList", standardTypeList);
        model.addAttribute("channelTpls", (Object)channelTpls);
        model.addAttribute("contentTpls", (Object)contentTpls);
        model.addAttribute("parentList", parentList);
        model.addAttribute("typeList", typeList);
        model.addAttribute("category", (Object)category);
        model.addAttribute("standardTypeIds", (Object)standardTypeIds);
        model.addAttribute("itemList", itemList);
        return "category/edit";
    }

    @RequestMapping(value={"/category/o_save.do"})
    public String save(Category bean, Long root, Long typeId, Long[] brandIds, Long[] standardTypeIds, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean.setAttr(RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_"));
        bean = this.manager.save(bean, root, typeId, brandIds, standardTypeIds);
        log.info("save Category. id={}", (Object)bean.getId());
        model.addAttribute("root", (Object)root);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/category/o_update.do"})
    public String update(Category bean, Long root, Long parentId, Long[] brandIds, Long[] standardTypeIds, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate((Long)bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Map attr = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_");
        bean = this.manager.update(bean, parentId, null, brandIds, attr, standardTypeIds);
        log.info("update Category. id={}.", (Object)bean.getId());
        return this.list(root, request, model);
    }

    @RequestMapping(value={"/category/o_delete.do"})
    public String delete(Long[] ids, Long root, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            Category[] beans;
            Category[] categoryArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                Category bean = categoryArray[n2];
                log.info("delete Category. id={}", (Object)bean.getId());
                ++n2;
            }
        }
        catch (Exception e) {
            errors.addErrorString(this.productMng.getTipFile("Please.delete.the.goods.and.other.related.data.from.the.modified.classification"));
            return errors.showErrorPage(model);
        }
        return this.list(root, request, model);
    }

    @RequestMapping(value={"/category/v_checkPath.do"})
    public String checkPath(String path, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((String)path) || !this.manager.checkPath(SiteUtils.getWebId((HttpServletRequest)request), path)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
        } else {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
        }
        return null;
    }

    @RequestMapping(value={"/category/o_priority.do"})
    public String priority(Long[] wids, Long root, Integer[] priority, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(root, request, model);
    }

    private WebErrors validateTree(String path, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    private WebErrors validateSave(Category bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        bean.setWebsite(SiteUtils.getWeb((HttpServletRequest)request));
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private WebErrors validatePriority(Long[] wids, Integer[] priority, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifEmpty((Object[])wids, "wids")) {
            return errors;
        }
        if (errors.ifEmpty((Object[])priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("wids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            this.vldExist(wids[i], errors);
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }

    private void vldExist(Long id, WebErrors errors) {
        if (errors.hasErrors()) {
            return;
        }
        Category entity = this.manager.findById(id);
        errors.ifNotExist((Object)entity, Category.class, (Serializable)id);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

