/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.DataBackup;
import com.jspgou.cms.manager.DataBackupMng;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.core.entity.EmailSender;
import com.jspgou.core.entity.Global;
import com.jspgou.core.entity.MessageTemplate;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.GlobalMng;
import com.jspgou.core.manager.UserMng;
import com.jspgou.core.manager.WebsiteMng;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ConfigAct {
    private final Logger log = LoggerFactory.getLogger(ConfigAct.class);
    @Autowired
    private WebsiteMng websiteMng;
    @Autowired
    private GlobalMng globalMng;
    @Autowired
    private UserMng userMng;
    @Autowired
    private DataBackupMng dataBackupMng;

    @RequestMapping(value={"/config/v_global_edit.do"})
    public String globalEdit(HttpServletRequest request, ModelMap model) {
        model.addAttribute("global", (Object)SiteUtils.getWeb((HttpServletRequest)request).getGlobal());
        return "config/global_edit";
    }

    @RequestMapping(value={"/config/o_global_update.do"})
    public String globalUpdate(Global global, HttpServletRequest request, ModelMap model) {
        global.setId(SiteUtils.getWeb((HttpServletRequest)request).getGlobal().getId());
        this.globalMng.update(global);
        this.log.info("update Global success.");
        model.addAttribute("message", (Object)"global.success");
        return this.globalEdit(request, model);
    }

    @RequestMapping(value={"/config/v_basic_edit.do"})
    public String basicEdit(HttpServletRequest request, ModelMap model) {
        model.addAttribute("website", (Object)SiteUtils.getWeb((HttpServletRequest)request));
        return "config/basic_edit";
    }

    @RequestMapping(value={"/config/o_basic_update.do"})
    public String basicUpdate(Website website, HttpServletRequest request, ModelMap model) {
        website.setId(SiteUtils.getWebId((HttpServletRequest)request));
        this.websiteMng.update(website);
        this.log.info("update website success. id={}", (Object)website.getId());
        model.addAttribute("message", (Object)"global.success");
        return this.basicEdit(request, model);
    }

    @RequestMapping(value={"/config/v_sso_edit.do"})
    public String ssoAuthenticateEdit(HttpServletRequest request, ModelMap model) {
        Website website = this.websiteMng.get();
        model.addAttribute("ssoMap", (Object)website.getSsoAttr());
        model.addAttribute("configAttr", (Object)website.getWebsiteAttr());
        return "config/sso_edit";
    }

    @RequestMapping(value={"/config/o_sso_update.do"})
    public String ssoAuthenticateUpdate(HttpServletRequest request, ModelMap model) {
        Map ssoMap = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_");
        this.websiteMng.updateSsoAttr(ssoMap);
        model.addAttribute("message", (Object)"global.success");
        this.log.info("update attrs of Config.");
        return this.ssoAuthenticateEdit(request, model);
    }

    @RequestMapping(value={"/config/v_shop_edit.do"})
    public String shopEdit(HttpServletRequest request, ModelMap model) {
        model.addAttribute("config", (Object)SiteUtils.getWeb((HttpServletRequest)request));
        return "config/basic_edit";
    }

    @RequestMapping(value={"/config/o_shop_update.do"})
    public String shopUpdate(Website website, HttpServletRequest request, ModelMap model) {
        website.setId(SiteUtils.getWebId((HttpServletRequest)request));
        this.websiteMng.update(website);
        this.log.info("update website success. id={}", (Object)website.getId());
        model.addAttribute("message", (Object)"global.success");
        return this.basicEdit(request, model);
    }

    @RequestMapping(value={"/config/v_email_edit.do"})
    public String emailEdit(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        model.addAttribute("emailSender", (Object)web.getEmailSender());
        model.addAttribute("messageMap", (Object)web.getMessages());
        return "config/email_edit";
    }

    @RequestMapping(value={"/config/o_email_update.do"})
    public String emailUpdate(EmailSender emailSender, String resetPasswordSubject, String resetPasswordText, String activeTitle, String activeTxt, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEmail(request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        web.setEmailSender(emailSender);
        Map messages = web.getMessages();
        MessageTemplate resetPassword = new MessageTemplate();
        resetPassword.setSubject(resetPasswordSubject);
        resetPassword.setText(resetPasswordText);
        resetPassword.setActiveTitle(activeTitle);
        resetPassword.setActiveTxt(activeTxt);
        messages.put("resetPassword", resetPassword);
        this.websiteMng.update(web);
        this.log.info("update EmailSender success.");
        return this.emailEdit(request, model);
    }

    @RequestMapping(value={"/config/o_email_send_test.do"})
    public String sendEmailTest(EmailSender email, String to, MessageTemplate tpl, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        try {
            String base = new String(web.getUrlBuff(true));
            this.userMng.senderEmail(Long.valueOf(0L), "Test_Username", base, to, "Test_ResetKey", "Test_ResetPassword", email, tpl);
            ResponseUtils.renderJson((HttpServletResponse)response, (String)new JSONObject().put("success", true).toString());
        }
        catch (Exception e) {
            JSONObject json = new JSONObject();
            json.put("success", false);
            json.put("message", (Object)e.getMessage());
            ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
        }
        return null;
    }

    @RequestMapping(value={"/config/v_dataBackup.do"})
    public String v_dataBackup(HttpServletRequest request, ModelMap model) {
        DataBackup dataBackup = this.dataBackupMng.getDataBackup();
        model.addAttribute("dataBackup", (Object)dataBackup);
        return "config/dataBackup";
    }

    @RequestMapping(value={"/config/o_dataBackup.do"})
    public void o_dataBackup(DataBackup bean, HttpServletRequest request, ModelMap model, HttpServletResponse response) throws UnsupportedEncodingException, IOException {
        this.dataBackupMng.update(bean);
        response.setContentType("application/x-download;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + bean.getDataBaseName() + new Date().getTime() + ".sql");
        PrintWriter out = response.getWriter();
        out.print(this.backup(bean));
        out.flush();
        out.close();
    }

    private String backup(DataBackup bean) {
        String outStr = "";
        try {
            String inStr;
            Runtime rt = Runtime.getRuntime();
            Process child = rt.exec("cmd /c mysqldump -u" + bean.getUsername() + " -p" + bean.getPassword() + " -h" + bean.getAddress() + " " + bean.getDataBaseName());
            InputStream in = child.getInputStream();
            InputStreamReader xx = new InputStreamReader(in, "utf-8");
            StringBuffer sb = new StringBuffer("");
            BufferedReader br = new BufferedReader(xx);
            while ((inStr = br.readLine()) != null) {
                sb.append(String.valueOf(inStr) + "\r\n");
            }
            outStr = sb.toString();
            child.waitFor();
            in.close();
            xx.close();
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outStr;
    }

    private WebErrors validateEmail(HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }
}

