/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Consult;
import com.jspgou.cms.manager.ConsultMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ConsultAct {
    private static final Logger log = LoggerFactory.getLogger(ConsultAct.class);
    @Autowired
    private ConsultMng manager;

    @RequestMapping(value={"/consult/v_list.do"})
    public String list(Date startTime, Date endTime, Integer pageNo, HttpServletRequest request, ModelMap model) {
        String userName = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"userName");
        userName = StringUtils.trim((String)userName);
        String productName = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"productName");
        productName = StringUtils.trim((String)productName);
        Pagination pagination = this.manager.getPage(null, userName, productName, startTime, endTime, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request), true);
        if (!StringUtils.isBlank((String)userName)) {
            model.addAttribute("userName", (Object)userName);
        }
        if (!StringUtils.isBlank((String)productName)) {
            model.addAttribute("productName", (Object)productName);
        }
        model.addAttribute("startTime", (Object)startTime);
        model.addAttribute("endTime", (Object)endTime);
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pageNo);
        return "consult/list";
    }

    @RequestMapping(value={"/consult/v_add.do"})
    public String add(ModelMap model) {
        return "consult/add";
    }

    @RequestMapping(value={"/consult/v_edit.do"})
    public String edit(Long id, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("consult", (Object)this.manager.findById(id));
        model.addAttribute("pageNo", (Object)pageNo);
        return "consult/edit";
    }

    @RequestMapping(value={"/consult/o_save.do"})
    public String save(Consult bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        log.info("save Consult id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/consult/o_update.do"})
    public String update(Long id, String adminReplay, HttpServletRequest request, ModelMap model, Integer pageNo) {
        Consult bean = this.manager.findById(id);
        bean.setAdminReplay(adminReplay);
        this.manager.update(bean);
        model.addAttribute("pageNo", (Object)pageNo);
        log.info("update Consult id={}.", (Object)bean.getId());
        return this.list(null, null, pageNo, request, model);
    }

    @RequestMapping(value={"/consult/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Consult[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Consult[] consultArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Consult bean = consultArray[n2];
            log.info("delete Consult id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(null, null, SimplePage.cpn((Integer)pageNo), request, model);
    }

    private WebErrors validateSave(Consult bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        Consult entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, Consult.class, (Serializable)id);
    }
}

