/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Discuss;
import com.jspgou.cms.manager.DiscussMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class DiscussAct {
    private static final Logger log = LoggerFactory.getLogger(DiscussAct.class);
    @Autowired
    private DiscussMng manager;

    @RequestMapping(value={"/discuss/v_list.do"})
    public String list(Date startTime, Date endTime, Integer pageNo, HttpServletRequest request, ModelMap model) {
        String userName = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"userName");
        userName = StringUtils.trim((String)userName);
        String productName = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"productName");
        productName = StringUtils.trim((String)productName);
        Pagination pagination = this.manager.getPage(null, userName, productName, startTime, endTime, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request), true);
        if (!StringUtils.isBlank((String)userName)) {
            model.addAttribute("userName", (Object)userName);
        }
        if (!StringUtils.isBlank((String)productName)) {
            model.addAttribute("productName", (Object)productName);
        }
        model.addAttribute("startTime", (Object)startTime);
        model.addAttribute("endTime", (Object)endTime);
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pageNo);
        return "discuss/list";
    }

    @RequestMapping(value={"/discuss/v_add.do"})
    public String add(ModelMap model) {
        return "discuss/add";
    }

    @RequestMapping(value={"/discuss/v_edit.do"})
    public String edit(Long id, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("discuss", (Object)this.manager.findById(id));
        model.addAttribute("pageNo", (Object)pageNo);
        return "discuss/edit";
    }

    @RequestMapping(value={"/discuss/o_save.do"})
    public String save(Discuss bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        log.info("save Discuss id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/discuss/o_update.do"})
    public String update(Discuss bean, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update Discuss id={}.", (Object)bean.getId());
        return this.list(null, null, pageNo, request, model);
    }

    @RequestMapping(value={"/discuss/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Discuss[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Discuss[] discussArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Discuss bean = discussArray[n2];
            log.info("delete Discuss id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(null, null, pageNo, request, model);
    }

    private WebErrors validateSave(Discuss bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        Discuss entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, Discuss.class, (Serializable)id);
    }
}

