/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Exended;
import com.jspgou.cms.entity.ExendedItem;
import com.jspgou.cms.entity.ProductType;
import com.jspgou.cms.manager.ExendedItemMng;
import com.jspgou.cms.manager.ExendedMng;
import com.jspgou.cms.manager.ProductTypeMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ExendedAct {
    private static final Logger log = LoggerFactory.getLogger(ExendedAct.class);
    @Autowired
    private ExendedMng manager;
    @Autowired
    private ProductTypeMng productTypeMng;
    @Autowired
    private ExendedItemMng exendedItemMng;

    @RequestMapping(value={"/exended/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return "exended/list";
    }

    @RequestMapping(value={"/exended/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        List<ProductType> ptList = this.productTypeMng.getList(web.getId());
        model.addAttribute("ptList", ptList);
        return "exended/add";
    }

    @RequestMapping(value={"/exended/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Long[] typeIds = this.manager.findById(id).getProductTypeIds();
        ArrayList<ExendedItem> list = new ArrayList<ExendedItem>();
        list.addAll(this.manager.findById(id).getItems());
        List<ProductType> ptList = this.productTypeMng.getList(web.getId());
        model.addAttribute("ptList", ptList);
        model.addAttribute("list", list);
        model.addAttribute("typeIds", (Object)typeIds);
        model.addAttribute("exended", (Object)this.manager.findById(id));
        return "exended/edit";
    }

    @RequestMapping(value={"/exended/o_save.do"})
    public String save(Exended bean, Long[] typeIds, String[] itemName, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean, typeIds);
        this.addExendedItems(bean, itemName);
        log.info("save exended id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/exended/o_update.do"})
    public String update(Exended bean, Long[] typeIds, Long[] itemId, String[] itemName, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean, typeIds);
        this.updateExendedItems(bean, itemId, itemName);
        log.info("update Exended id={}.", (Object)bean.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/exended/o_priority.do"})
    public String priority(Integer pageNo, Long[] wids, Integer[] priority, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/exended/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Exended[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Exended[] exendedArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Exended bean = exendedArray[n2];
            log.info("delete Exended id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    private void addExendedItems(Exended bean, String[] itemName) {
        if (itemName != null) {
            int i = 0;
            int len = itemName.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)itemName[i])) {
                    ExendedItem item = new ExendedItem();
                    item.setName(itemName[i]);
                    item.setExended(bean);
                    this.exendedItemMng.save(item);
                }
                ++i;
            }
        }
    }

    private void updateExendedItems(Exended bean, Long[] itemId, String[] itemName) {
        Set<ExendedItem> set = bean.getItems();
        if (itemId != null) {
            for (ExendedItem e : set) {
                if (Arrays.asList(itemId).contains(e.getId())) continue;
                this.exendedItemMng.deleteById(e.getId());
            }
        } else {
            for (ExendedItem e : set) {
                this.exendedItemMng.deleteById(e.getId());
            }
        }
        if (itemName != null) {
            int i = 0;
            int len = itemName.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)itemName[i])) {
                    ExendedItem item;
                    if (itemId != null && i < itemId.length) {
                        item = this.exendedItemMng.findById(itemId[i]);
                        item.setName(itemName[i]);
                        item.setExended(bean);
                        this.exendedItemMng.update(item);
                    } else {
                        item = new ExendedItem();
                        item.setName(itemName[i]);
                        item.setExended(bean);
                        this.exendedItemMng.save(item);
                    }
                }
                ++i;
            }
        }
    }

    public static Long[] fetchProductTypeIds(Collection<ProductType> productTypes) {
        Long[] ids = new Long[productTypes.size()];
        int i = 0;
        for (ProductType sdt : productTypes) {
            ids[i++] = sdt.getId();
        }
        return ids;
    }

    private WebErrors validateSave(Exended bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        Exended entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, Exended.class, (Serializable)id);
    }

    private WebErrors validatePriority(Long[] wids, Integer[] priority, HttpServletRequest request) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifEmpty((Object[])wids, "ids")) {
            return errors;
        }
        if (errors.ifEmpty((Object[])priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("ids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            if (this.vldExist(wids[i], web.getId(), errors)) {
                return errors;
            }
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }
}

