/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Gathering;
import com.jspgou.cms.manager.GatheringMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class GatheringAct {
    private static final Logger log = LoggerFactory.getLogger(GatheringAct.class);
    @Autowired
    private GatheringMng manager;

    @RequestMapping(value={"/Gathering/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return "Gathering/list";
    }

    @RequestMapping(value={"/Gathering/v_add.do"})
    public String add(ModelMap model) {
        return "Gathering/add";
    }

    @RequestMapping(value={"/Gathering/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("gathering", (Object)this.manager.findById(id));
        model.addAttribute("order", (Object)this.manager.findById(id).getIndent());
        return "Gathering/edit";
    }

    @RequestMapping(value={"/Gathering/o_save.do"})
    public String save(Gathering bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save Gathering id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/Gathering/o_update.do"})
    public String update(Gathering bean, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update Gathering id={}.", (Object)bean.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/Gathering/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Gathering[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Gathering[] gatheringArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Gathering bean = gatheringArray[n2];
            log.info("delete Gathering id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    private WebErrors validateSave(Gathering bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        Gathering entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, Gathering.class, (Serializable)id);
    }
}

