/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Brand;
import com.jspgou.cms.entity.Gift;
import com.jspgou.cms.manager.GiftMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class GiftAct {
    private static final Logger log = LoggerFactory.getLogger(GiftAct.class);
    @Autowired
    private ProductMng productMng;
    @Autowired
    private GiftMng manager;

    @RequestMapping(value={"/gift/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPageGift(SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return "gift/list";
    }

    @RequestMapping(value={"/gift/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        return "gift/add";
    }

    @RequestMapping(value={"/gift/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("gift", (Object)this.manager.findById(id));
        return "gift/edit";
    }

    @RequestMapping(value={"/gift/o_save.do"})
    public String save(Gift bean, HttpServletRequest request, ModelMap model) {
        bean = this.manager.save(bean);
        log.info("save brand. id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/gift/o_update.do"})
    public String update(Gift gift, String text, Long[] typeIds, Integer pageNo, HttpServletRequest request, ModelMap model) {
        this.manager.updateByUpdater(gift);
        log.info("update brand. id={}.", (Object)gift.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/gift/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            Gift[] beans;
            Gift[] giftArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                Gift bean = giftArray[n2];
                log.info("delete brand. id={}", (Object)bean.getId());
                ++n2;
            }
        }
        catch (Exception e) {
            errors.addErrorString(this.productMng.getTipFile("Pleasedtrofgiftin"));
            return errors.showErrorPage(model);
        }
        return this.list(pageNo, request, model);
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private WebErrors validatePriority(Long[] wids, Integer[] priority, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifEmpty((Object[])wids, "wids")) {
            return errors;
        }
        if (errors.ifEmpty((Object[])priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("wids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            this.vldExist(wids[i], errors);
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }

    private boolean vldExist(Long id, WebErrors errors) {
        Gift entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, Brand.class, (Serializable)id);
    }
}

