/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Logistics;
import com.jspgou.cms.manager.LogisticsMng;
import com.jspgou.common.util.StrUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class LogisticsAct {
    private static final Logger log = LoggerFactory.getLogger(LogisticsAct.class);
    @Autowired
    private LogisticsMng manager;

    @RequestMapping(value={"/logistics/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        List<Logistics> list = this.manager.getAllList();
        model.addAttribute("list", list);
        return "logistics/list";
    }

    @RequestMapping(value={"/logistics/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        return "logistics/add";
    }

    @RequestMapping(value={"/logistics/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("logistics", (Object)this.manager.findById(id));
        return "logistics/edit";
    }

    @RequestMapping(value={"/logistics/o_save.do"})
    public String save(Logistics bean, String text, Long[] typeIds, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean, text);
        log.info("save brand. id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/logistics/o_update.do"})
    public String update(Logistics bean, String text, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean, text);
        log.info("update brand. id={}.", (Object)bean.getId());
        return this.list(request, model);
    }

    @RequestMapping(value={"/logistics/o_delete.do"})
    public String delete(Long[] ids, HttpServletRequest request, ModelMap model) {
        Logistics[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Logistics[] logisticsArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Logistics bean = logisticsArray[n2];
            log.info("delete brand. id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(request, model);
    }

    @RequestMapping(value={"/logistics/o_priority.do"})
    public String priority(Long[] wids, Integer[] priority, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(request, model);
    }

    private WebErrors validateSave(Logistics bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        bean.setWebUrl(StrUtils.handelUrl((String)bean.getWebUrl()));
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateUpdate(Logistics bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Long id = bean.getId();
        bean.setWebUrl(StrUtils.handelUrl((String)bean.getWebUrl()));
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private WebErrors validatePriority(Long[] wids, Integer[] priority, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifEmpty((Object[])wids, "wids")) {
            return errors;
        }
        if (errors.ifEmpty((Object[])priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("wids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            this.vldExist(wids[i], errors);
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }

    private boolean vldExist(Long id, WebErrors errors) {
        Logistics entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, Logistics.class, (Serializable)id);
    }
}

