/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Gathering;
import com.jspgou.cms.entity.Order;
import com.jspgou.cms.entity.OrderItem;
import com.jspgou.cms.entity.OrderReturn;
import com.jspgou.cms.entity.Payment;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductFashion;
import com.jspgou.cms.entity.Shipping;
import com.jspgou.cms.entity.ShopAdmin;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.ShopScore;
import com.jspgou.cms.manager.GatheringMng;
import com.jspgou.cms.manager.OrderItemMng;
import com.jspgou.cms.manager.OrderMng;
import com.jspgou.cms.manager.OrderReturnMng;
import com.jspgou.cms.manager.PaymentMng;
import com.jspgou.cms.manager.ProductFashionMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ShippingMng;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.cms.manager.ShopScoreMng;
import com.jspgou.cms.web.threadvariable.AdminThread;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class OrderAct {
    private static final Logger log = LoggerFactory.getLogger(OrderAct.class);
    public static final String ALL = "all";
    public static final String PENDING = "pending";
    public static final String PROSESSING = "processing";
    public static final String DELIVERED = "delivered";
    public static final String COMPLETE = "complete";
    public static final String[] TYPES = new String[]{"all", "pending", "processing", "delivered", "complete"};
    private static final String ALIPAY_GATEWAY_NEW = "https://mapi.alipay.com/gateway.do?";
    @Autowired
    private ShippingMng shippingMng;
    @Autowired
    private PaymentMng paymentMng;
    @Autowired
    private OrderMng manager;
    @Autowired
    private OrderReturnMng orderReturnMng;
    @Autowired
    private ShopMemberMng shopMemberMng;
    @Autowired
    private ShopScoreMng shopScoreMng;
    @Autowired
    private ProductMng productMng;
    @Autowired
    private ProductFashionMng productFashionMng;
    @Autowired
    private OrderItemMng orderItemMng;
    @Autowired
    private GatheringMng gatheringMng;

    @RequestMapping(value={"/order/v_list.do"})
    public String list(Long code, Integer status, Integer paymentStatus, Integer shippingStatus, Long paymentId, Long shoppingId, Date startTime, Date endTime, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String userName = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"userName");
        userName = StringUtils.trim((String)userName);
        Pagination pagination = this.manager.getPage(web.getId(), null, null, userName, paymentId, shoppingId, startTime, endTime, null, null, status, paymentStatus, shippingStatus, code, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        List<Shipping> shippingList = this.shippingMng.getList(web.getId(), true);
        List<Payment> paymentList = this.paymentMng.getList(web.getId(), true);
        model.addAttribute("paymentList", paymentList);
        model.addAttribute("shippingList", shippingList);
        model.addAttribute("paymentId", (Object)paymentId);
        model.addAttribute("shoppingId", (Object)shoppingId);
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("startTime", (Object)startTime);
        model.addAttribute("endTime", (Object)endTime);
        model.addAttribute("status", (Object)status);
        model.addAttribute("paymentStatus", (Object)paymentStatus);
        model.addAttribute("shippingStatus", (Object)shippingStatus);
        return "order/list";
    }

    @RequestMapping(value={"/order/v_view.do"})
    public String view(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("order", (Object)this.manager.findById(id));
        return "order/view";
    }

    @RequestMapping(value={"/order/o_affirm.do"})
    public String affirm(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Order order = this.manager.findById(id);
        if (order.getStatus() == 1) {
            order.setStatus(2);
            this.manager.updateByUpdater(order);
        }
        model.addAttribute("order", (Object)order);
        return "order/view";
    }

    @RequestMapping(value={"/order/o_abolish.do"})
    public String abolish(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Order order = this.manager.findById(id);
        if (order.getStatus() != 4 && order.getShippingStatus() != 2 && order.getPaymentStatus() != 2) {
            order.setStatus(3);
            for (OrderItem item : order.getItems()) {
                Product product = item.getProduct();
                if (item.getProductFash() != null) {
                    ProductFashion fashion = item.getProductFash();
                    fashion.setStockCount(fashion.getStockCount() + item.getCount());
                    product.setStockCount(product.getStockCount() + item.getCount());
                    this.productFashionMng.update(fashion);
                } else {
                    product.setStockCount(product.getStockCount() + item.getCount());
                }
                this.productMng.updateByUpdater(product);
            }
            ShopMember member = order.getMember();
            member.setFreezeScore(member.getFreezeScore() - order.getScore());
            this.shopMemberMng.update(member);
            List<ShopScore> list = this.shopScoreMng.getlist(Long.toString(order.getCode()));
            for (ShopScore s : list) {
                this.shopScoreMng.deleteById(s.getId());
            }
            this.manager.updateByUpdater(order);
        }
        model.addAttribute("order", (Object)order);
        return "order/view";
    }

    @RequestMapping(value={"/order/v_payment.do"})
    public String zhifu(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Order order = this.manager.findById(id);
        model.addAttribute("order", (Object)order);
        return "order/payment";
    }

    @RequestMapping(value={"/order/v_shipments.do"})
    public String shipmentses(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Order order = this.manager.findById(id);
        model.addAttribute("order", (Object)order);
        return "order/shipments";
    }

    @RequestMapping(value={"/order/o_payment.do"})
    public String payment(Gathering bean, Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Order order = this.manager.findById(id);
        ShopAdmin admin = AdminThread.get();
        bean.setShopAdmin(admin);
        bean.setIndent(order);
        if (order.getPaymentStatus() == 1 && order.getPayment().getType() == 2) {
            this.gatheringMng.save(bean);
            order.setPaymentStatus(2);
            this.manager.updateByUpdater(order);
        }
        model.addAttribute("order", (Object)order);
        return "order/view";
    }

    @RequestMapping(value={"/order/o_accomplish.do"})
    public String accomplish(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Order order = this.manager.findById(id);
        if (order.getShippingStatus() == 2 && order.getStatus() == 2 && order.getPaymentStatus() == 2) {
            order.setStatus(4);
            ShopMember member = order.getMember();
            member.setFreezeScore(member.getFreezeScore() - order.getScore());
            member.setScore(member.getScore() + order.getScore());
            this.shopMemberMng.update(member);
            List<ShopScore> list = this.shopScoreMng.getlist(Long.toString(order.getCode()));
            for (ShopScore s : list) {
                s.setStatus(true);
                this.shopScoreMng.update(s);
            }
            this.manager.updateByUpdater(order);
            this.manager.updateliRun(id);
        }
        model.addAttribute("order", (Object)order);
        return "order/view";
    }

    @RequestMapping(value={"/order/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        List<Shipping> shippingList = this.shippingMng.getList(web.getId(), true);
        List<Payment> paymentList = this.paymentMng.getList(web.getId(), true);
        model.addAttribute("order", (Object)this.manager.findById(id));
        model.addAttribute("paymentList", paymentList);
        model.addAttribute("shippingList", shippingList);
        model.addAttribute("orderReturn", (Object)this.orderReturnMng.findByOrderId(id));
        return "order/edit";
    }

    @RequestMapping(value={"/order/o_update.do"})
    public String update(Long id, String comments, Long shippingId, Long paymentId, Long[] itemId, Integer[] itemCount, Double[] itemPrice, Double totalPrice, Integer pageNo, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        WebErrors errors = this.validateUpdate(id, shippingId, itemId, itemCount, itemPrice, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Order order = this.manager.findById(id);
        int score = 0;
        int weight = 0;
        double price = 0.0;
        int i = 0;
        while (i < itemId.length) {
            OrderItem orderItem = this.orderItemMng.findById(itemId[i]);
            Product product = orderItem.getProduct();
            product.setStockCount(product.getStockCount() + orderItem.getCount() - itemCount[i]);
            if (orderItem.getProductFash() != null) {
                ProductFashion productFash = orderItem.getProductFash();
                productFash.setStockCount(productFash.getStockCount() + orderItem.getCount() - itemCount[i]);
                this.productFashionMng.update(productFash);
            }
            orderItem.setCount(itemCount[i]);
            orderItem.setSalePrice(itemPrice[i]);
            score += itemCount[i] * orderItem.getProduct().getScore();
            weight += orderItem.getProduct().getWeight() * itemCount[i];
            price = orderItem.getProductFash() != null ? (price += itemPrice[i] * (double)itemCount[i].intValue()) : (price += itemPrice[i] * (double)itemCount[i].intValue());
            this.orderItemMng.updateByUpdater(orderItem);
            this.productMng.updateByUpdater(product);
            ++i;
        }
        order.setScore(score);
        order.setWeight(Double.valueOf(weight));
        order.setProductPrice(price);
        double freight = this.shippingMng.findById(shippingId).calPrice(Double.valueOf(weight));
        order.setFreight(freight);
        order.setTotal(freight + price);
        order.setComments(comments);
        order.setShipping(this.shippingMng.findById(shippingId));
        order.setPayment(this.paymentMng.findById(paymentId));
        order.setLastModified(new Timestamp(System.currentTimeMillis()));
        this.manager.updateByUpdater(order);
        log.info("update Order, id={}.", (Object)order.getId());
        return this.list(null, null, null, null, null, null, null, null, pageNo, request, model);
    }

    @RequestMapping(value={"/order/o_returnMoney.do"})
    public void returnMoney(Long id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        OrderReturn orderReturn = this.orderReturnMng.findByOrderId(id);
        if (orderReturn.getPayType() == 2) {
            Payment pay = this.paymentMng.findById(3L);
            PrintWriter out = null;
            try {
                try {
                    String aliURL = this.alipayReturn(pay, web, orderReturn, request, model);
                    response.setContentType("text/html;charset=UTF-8");
                    out = response.getWriter();
                    out.print(aliURL);
                }
                catch (Exception exception) {
                    out.close();
                }
            }
            finally {
                out.close();
            }
        }
    }

    private String alipayReturn(Payment pay, Website web, OrderReturn orderReturn, HttpServletRequest request, ModelMap model) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date1 = sdf.format(date);
        String batch_no = date1.concat(String.valueOf(orderReturn.getId() * 100L));
        String refund_date = sdf1.format(date);
        String batch_num = String.valueOf(1);
        String detail_data = String.valueOf(orderReturn.getOrder().getId().toString()) + "^" + 1.0 + "^" + orderReturn.getShopDictionary().getName();
        String notify_url = "http://" + web.getDomain() + "/cart/aliReturn.jspx";
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("batch_no", batch_no);
        sParaTemp.put("refund_date", refund_date);
        sParaTemp.put("batch_num", batch_num);
        sParaTemp.put("detail_data", detail_data);
        sParaTemp.put("notify_url", notify_url);
        String sHtmlText = null;
        try {
            sHtmlText = OrderAct.refund_fastpay_by_platform_pwd(sParaTemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sHtmlText;
    }

    public static String refund_fastpay_by_platform_pwd(Map<String, String> sParaTemp) throws Exception {
        sParaTemp.put("service", "refund_fastpay_by_platform_pwd");
        sParaTemp.put("_input_charset", "UTF-8");
        String strButtonName = "\u9000\u6b3e";
        return OrderAct.buildForm(sParaTemp, ALIPAY_GATEWAY_NEW, "get", strButtonName);
    }

    public static String buildForm(Map<String, String> sParaTemp, String gateway, String strMethod, String strButtonName) {
        Map<String, String> sPara = OrderAct.buildRequestPara(sParaTemp);
        ArrayList<String> keys = new ArrayList<String>(sPara.keySet());
        StringBuffer sbHtml = new StringBuffer();
        sbHtml.append("<form id=\"alipaysubmit\" name=\"alipaysubmit\" action=\"" + gateway + "_input_charset=" + "UTF-8" + "\" method=\"" + strMethod + "\">");
        int i = 0;
        while (i < keys.size()) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            sbHtml.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>");
            ++i;
        }
        sbHtml.append("<input type=\"submit\" value=\"" + strButtonName + "\" style=\"display:none;\"></form>");
        sbHtml.append("<script>document.forms['alipaysubmit'].submit();</script>");
        return sbHtml.toString();
    }

    private static Map<String, String> buildRequestPara(Map<String, String> sParaTemp) {
        Map<String, String> sPara = OrderAct.paraFilter(sParaTemp);
        String mysign = OrderAct.buildMysign(sPara);
        sPara.put("sign", mysign);
        sPara.put("sign_type", "MD5");
        return sPara;
    }

    public static String buildMysign(Map<String, String> sArray) {
        String prestr = OrderAct.createLinkString(sArray);
        prestr = String.valueOf(prestr) + sArray.get("key");
        String mysign = OrderAct.md5(prestr);
        return mysign;
    }

    public static String md5(String text) {
        return DigestUtils.md5Hex((byte[])OrderAct.getContentBytes(text, "UTF-8"));
    }

    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        int i = 0;
        while (i < keys.size()) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            prestr = i == keys.size() - 1 ? String.valueOf(prestr) + key + "=" + value : String.valueOf(prestr) + key + "=" + value + "&";
            ++i;
        }
        return prestr;
    }

    public static Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (sArray == null || sArray.size() <= 0) {
            return result;
        }
        for (String key : sArray.keySet()) {
            String value = sArray.get(key);
            if (value == null || value.equals("") || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) continue;
            result.put(key, value);
        }
        return result;
    }

    @RequestMapping(value={"/order/ajaxtotalDeliveryFee.do"})
    public void ajaxtotalDeliveryFee(Long deliveryMethod, Double weight, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        ShopMember member = MemberThread.get();
        JSONObject json = new JSONObject();
        if (member == null) {
            json.put("status", 0);
        }
        Shipping shipping = this.shippingMng.findById(deliveryMethod);
        Double freight = shipping.calPrice(weight);
        json.put("status", 1);
        json.put("freight", (Object)freight);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    private Integer findItem(Long[] itemIds, Long itemId) {
        int i = 0;
        while (i < itemIds.length) {
            if (itemIds[i].equals(itemId)) {
                return i;
            }
            ++i;
        }
        return null;
    }

    @RequestMapping(value={"/order/o_delete.do"})
    public String delete(Long[] ids, String type, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Order[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Order[] orderArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Order bean = orderArray[n2];
            log.info("delete Order, id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(null, null, null, null, null, null, null, null, pageNo, request, model);
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, Long shippingId, Long[] itemId, Integer[] itemCount, Double[] itemPrice, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        if (itemId == null || itemCount == null || itemPrice == null || itemId.length == 0 || itemId.length != itemCount.length || itemCount.length != itemPrice.length) {
            errors.addErrorString("order item invalid!");
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        Order entity = this.manager.findById(id);
        if (errors.ifNotExist((Object)entity, Order.class, (Serializable)id)) {
            return true;
        }
        if (!entity.getWebsite().getId().equals(webId)) {
            errors.notInWeb(Order.class, (Serializable)id);
            return true;
        }
        return false;
    }
}

