/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Order;
import com.jspgou.cms.entity.OrderItem;
import com.jspgou.cms.entity.OrderReturn;
import com.jspgou.cms.entity.PaymentPlugins;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductFashion;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.ShopScore;
import com.jspgou.cms.manager.OrderMng;
import com.jspgou.cms.manager.OrderReturnMng;
import com.jspgou.cms.manager.PaymentPluginsMng;
import com.jspgou.cms.manager.ProductFashionMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.cms.manager.ShopScoreMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class OrderReturnAct {
    private static final Logger log = LoggerFactory.getLogger(OrderReturnAct.class);
    private static final String ALIPAY_GATEWAY_NEW = "https://mapi.alipay.com/gateway.do?";
    @Autowired
    private OrderReturnMng manager;
    @Autowired
    private ProductMng productMng;
    @Autowired
    private ProductFashionMng productFashionMng;
    @Autowired
    private ShopMemberMng shopMemberMng;
    @Autowired
    private ShopScoreMng shopScoreMng;
    @Autowired
    private PaymentPluginsMng paymentPluginsMng;
    @Autowired
    private OrderMng orderMng;

    @RequestMapping(value={"/orderReturn/v_list.do"})
    public String list(Integer status, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(status, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("status", (Object)status);
        return "orderReturn/list";
    }

    @RequestMapping(value={"/orderReturn/v_view.do"})
    public String view(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("order", (Object)this.manager.findById(id).getOrder());
        return "orderReturn/view";
    }

    @RequestMapping(value={"/orderReturn/o_affirm.do"})
    public String affirm(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        OrderReturn entity = this.manager.findById(id);
        entity.setStatus(2);
        this.manager.update(entity);
        model.addAttribute("order", (Object)this.manager.findById(id).getOrder());
        return "orderReturn/view";
    }

    @RequestMapping(value={"/orderReturn/o_sendback.do"})
    public String sendback(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        OrderReturn entity = this.manager.findById(id);
        entity.setStatus(3);
        this.manager.update(entity);
        model.addAttribute("order", (Object)this.manager.findById(id).getOrder());
        return "orderReturn/view";
    }

    @RequestMapping(value={"/orderReturn/o_accomplish.do"})
    public String accomplish(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        OrderReturn entity = this.manager.findById(id);
        entity.setStatus(7);
        Order order = this.manager.findById(id).getOrder();
        order.setStatus(3);
        this.manager.update(entity);
        this.orderMng.updateByUpdater(order);
        model.addAttribute("order", (Object)this.manager.findById(id).getOrder());
        return "orderReturn/view";
    }

    @RequestMapping(value={"/orderReturn/o_reimburse.do"})
    public String reimburse(Long id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        OrderReturn entity;
        block8: {
            Website web = SiteUtils.getWeb((HttpServletRequest)request);
            WebErrors errors = this.validateEdit(id, request);
            if (errors.hasErrors()) {
                return errors.showErrorPage(model);
            }
            entity = this.manager.findById(id);
            PaymentPlugins paymentPlugins = this.paymentPluginsMng.findByCode("alipay");
            if (paymentPlugins != null) {
                PrintWriter out = null;
                try {
                    try {
                        String aliURL = this.alipayReturn(paymentPlugins, web, entity, request, model);
                        response.setContentType("text/html;charset=UTF-8");
                        out = response.getWriter();
                        out.print(aliURL);
                    }
                    catch (Exception exception) {
                        out.close();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    out.close();
                    throw throwable;
                }
                out.close();
            } else {
                ShopMember shopMember = entity.getOrder().getMember();
                shopMember.setMoney((double)shopMember.getFreezeScore().intValue() + entity.getMoney());
                this.shopMemberMng.update(shopMember);
            }
        }
        entity.setStatus(6);
        this.manager.update(entity);
        model.addAttribute("order", (Object)this.manager.findById(id).getOrder());
        return "orderReturn/view";
    }

    private String alipayReturn(PaymentPlugins paymentPlugins, Website web, OrderReturn orderReturn, HttpServletRequest request, ModelMap model) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date1 = sdf.format(date);
        String batch_no = date1.concat(String.valueOf(orderReturn.getId() * 100L));
        String refund_date = sdf1.format(date);
        String batch_num = String.valueOf(1);
        String detail_data = String.valueOf(orderReturn.getOrder().getId().toString()) + "^" + 1.0 + "^" + orderReturn.getShopDictionary().getName();
        String seller_email = paymentPlugins.getSellerEmail();
        String seller_user_id = paymentPlugins.getSellerKey();
        String notify_url = "http://" + web.getDomain() + "/cart/aliReturn.jspx";
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("partner", paymentPlugins.getPartner());
        sParaTemp.put("seller_email", seller_email);
        sParaTemp.put("seller_user_id", seller_user_id);
        sParaTemp.put("batch_no", batch_no);
        sParaTemp.put("refund_date", refund_date);
        sParaTemp.put("batch_num", batch_num);
        sParaTemp.put("detail_data", detail_data);
        sParaTemp.put("notify_url", notify_url);
        String sHtmlText = null;
        try {
            sHtmlText = OrderReturnAct.refund_fastpay_by_platform_pwd(sParaTemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sHtmlText;
    }

    public static String refund_fastpay_by_platform_pwd(Map<String, String> sParaTemp) throws Exception {
        sParaTemp.put("service", "refund_fastpay_by_platform_pwd");
        sParaTemp.put("_input_charset", "UTF-8");
        String strButtonName = "\u9000\u6b3e";
        return OrderReturnAct.buildForm(sParaTemp, ALIPAY_GATEWAY_NEW, "get", strButtonName);
    }

    public static String buildForm(Map<String, String> sParaTemp, String gateway, String strMethod, String strButtonName) {
        Map<String, String> sPara = OrderReturnAct.buildRequestPara(sParaTemp);
        ArrayList<String> keys = new ArrayList<String>(sPara.keySet());
        StringBuffer sbHtml = new StringBuffer();
        sbHtml.append("<form id=\"alipaysubmit\" name=\"alipaysubmit\" action=\"" + gateway + "_input_charset=" + "UTF-8" + "\" method=\"" + strMethod + "\">");
        int i = 0;
        while (i < keys.size()) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            sbHtml.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>");
            ++i;
        }
        sbHtml.append("<input type=\"submit\" value=\"" + strButtonName + "\" style=\"display:none;\"></form>");
        sbHtml.append("<script>document.forms['alipaysubmit'].submit();</script>");
        return sbHtml.toString();
    }

    private static Map<String, String> buildRequestPara(Map<String, String> sParaTemp) {
        Map<String, String> sPara = OrderReturnAct.paraFilter(sParaTemp);
        String mysign = OrderReturnAct.buildMysign(sPara);
        sPara.put("sign", mysign);
        sPara.put("sign_type", "MD5");
        return sPara;
    }

    public static String buildMysign(Map<String, String> sArray) {
        String prestr = OrderReturnAct.createLinkString(sArray);
        prestr = String.valueOf(prestr) + sArray.get("key");
        String mysign = OrderReturnAct.md5(prestr);
        return mysign;
    }

    public static String md5(String text) {
        return DigestUtils.md5Hex((byte[])OrderReturnAct.getContentBytes(text, "UTF-8"));
    }

    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        int i = 0;
        while (i < keys.size()) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            prestr = i == keys.size() - 1 ? String.valueOf(prestr) + key + "=" + value : String.valueOf(prestr) + key + "=" + value + "&";
            ++i;
        }
        return prestr;
    }

    public static Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (sArray == null || sArray.size() <= 0) {
            return result;
        }
        for (String key : sArray.keySet()) {
            String value = sArray.get(key);
            if (value == null || value.equals("") || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) continue;
            result.put(key, value);
        }
        return result;
    }

    @RequestMapping(value={"/orderReturn/o_salesreturn.do"})
    public String salesreturn(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        OrderReturn entity = this.manager.findById(id);
        entity.setStatus(5);
        for (OrderItem item : entity.getOrder().getItems()) {
            Product product = item.getProduct();
            if (item.getProductFash() != null) {
                ProductFashion fashion = item.getProductFash();
                fashion.setStockCount(fashion.getStockCount() + item.getCount());
                product.setStockCount(product.getStockCount() + item.getCount());
                product.setSaleCount(product.getSaleCount() - item.getCount());
                product.setLiRun(product.getLiRun() - (double)item.getCount().intValue() * (fashion.getSalePrice() - fashion.getCostPrice()));
                this.productFashionMng.update(fashion);
            } else {
                product.setLiRun(product.getLiRun() - (double)item.getCount().intValue() * (product.getSalePrice() - product.getCostPrice()));
                product.setSaleCount(product.getSaleCount() - item.getCount());
                product.setStockCount(product.getStockCount() + item.getCount());
            }
            this.productMng.updateByUpdater(product);
        }
        ShopMember member = entity.getOrder().getMember();
        member.setFreezeScore(member.getScore() - entity.getOrder().getScore());
        this.shopMemberMng.update(member);
        List<ShopScore> list = this.shopScoreMng.getlist(Long.toString(entity.getOrder().getCode()));
        for (ShopScore s : list) {
            this.shopScoreMng.deleteById(s.getId());
        }
        this.manager.update(entity);
        model.addAttribute("order", (Object)this.manager.findById(id).getOrder());
        return "orderReturn/view";
    }

    @RequestMapping(value={"/orderReturn/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        OrderReturn[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        OrderReturn[] orderReturnArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            OrderReturn bean = orderReturnArray[n2];
            log.info("delete OrderReturn id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(null, pageNo, request, model);
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        OrderReturn entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, OrderReturn.class, (Serializable)id);
    }
}

