/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Payment;
import com.jspgou.cms.entity.Shipping;
import com.jspgou.cms.manager.PaymentMng;
import com.jspgou.cms.manager.ShippingMng;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class PaymentAct {
    private static final Logger log = LoggerFactory.getLogger(PaymentAct.class);
    @Autowired
    private PaymentMng manager;
    @Autowired
    private ShippingMng shippingMng;

    @RequestMapping(value={"/payment/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        List<Payment> list = this.manager.getList(SiteUtils.getWebId((HttpServletRequest)request), true);
        model.addAttribute("list", list);
        return "payment/list";
    }

    @RequestMapping(value={"/payment/v_add.do"})
    public String add(String code, HttpServletRequest request, ModelMap model) {
        List<Shipping> shippingList = this.shippingMng.getList(SiteUtils.getWebId((HttpServletRequest)request), false);
        model.addAttribute("shippingList", shippingList);
        return "payment/add";
    }

    @RequestMapping(value={"/payment/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Payment payment = this.manager.findById(id);
        List<Shipping> shippingList = this.shippingMng.getList(SiteUtils.getWebId((HttpServletRequest)request), false);
        model.addAttribute("shippingIds", (Object)this.manager.findById(id).getShippingIds());
        model.addAttribute("shippingList", shippingList);
        model.addAttribute("payment", (Object)payment);
        return "payment/edit";
    }

    @RequestMapping(value={"/payment/o_save.do"})
    public String save(Payment bean, long[] shippingIds, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        if (bean.getIsDefault().booleanValue()) {
            List<Payment> list = this.manager.getList(1L, true);
            int i = 0;
            while (i < list.size()) {
                list.get(i).setIsDefault(false);
                this.manager.update(list.get(i));
                ++i;
            }
        }
        bean = this.manager.save(bean);
        this.manager.addShipping(bean, shippingIds);
        log.info("save Payment, id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/payment/o_update.do"})
    public String update(Payment bean, Integer pageNo, long[] shippingIds, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        if (bean.getIsDefault().booleanValue()) {
            List<Payment> list = this.manager.getList(1L, true);
            int i = 0;
            while (i < list.size()) {
                list.get(i).setIsDefault(false);
                this.manager.update(list.get(i));
                ++i;
            }
        }
        bean = this.manager.update(bean);
        this.manager.updateShipping(bean, shippingIds);
        log.info("update Payment, id={}.", (Object)bean.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/payment/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Payment[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Payment[] paymentArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Payment bean = paymentArray[n2];
            log.info("delete Payment, id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/payment/o_priority.do"})
    public String priority(Long[] wids, Integer[] priority, Integer pageNo, HttpServletRequest request, ModelMap model) {
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(pageNo, request, model);
    }

    private WebErrors validateSave(Payment bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        bean.setWebsite(web);
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        Payment entity = this.manager.findById(id);
        if (errors.ifNotExist((Object)entity, Payment.class, (Serializable)id)) {
            return true;
        }
        if (!entity.getWebsite().getId().equals(webId)) {
            errors.notInWeb(Payment.class, (Serializable)id);
            return true;
        }
        return false;
    }

    private Map<String, String> getCfg(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration e = request.getParameterNames();
        String param = "cfg_";
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(param)) continue;
            map.put(name.substring(param.length()), request.getParameter(name));
        }
        return map;
    }
}

