/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Payment;
import com.jspgou.cms.entity.PaymentPlugins;
import com.jspgou.cms.manager.PaymentPluginsMng;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class PaymentPluginsAct {
    private static final Logger log = LoggerFactory.getLogger(PaymentPluginsAct.class);
    @Autowired
    private PaymentPluginsMng manager;

    @RequestMapping(value={"/plugins/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        List<PaymentPlugins> list = this.manager.getList();
        HashSet<String> codeSet = new HashSet<String>();
        for (PaymentPlugins p : list) {
            codeSet.add(p.getCode());
        }
        model.addAttribute("list", list);
        model.addAttribute("codeSet", codeSet);
        return "plugins/list";
    }

    @RequestMapping(value={"/plugins/v_add.do"})
    public String add(String code, HttpServletRequest request, ModelMap model) {
        model.addAttribute("code", (Object)code);
        return "plugins/add";
    }

    @RequestMapping(value={"/plugins/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        PaymentPlugins paymentPlugins = this.manager.findById(id);
        model.addAttribute("paymentPlugins", (Object)paymentPlugins);
        return "plugins/edit";
    }

    @RequestMapping(value={"/plugins/o_save.do"})
    public String save(PaymentPlugins bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save Payment, id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/plugins/o_update.do"})
    public String update(PaymentPlugins bean, long[] shippingIds, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update Payment, id={}.", (Object)bean.getId());
        return this.list(request, model);
    }

    @RequestMapping(value={"/plugins/o_delete.do"})
    public String delete(Long[] ids, HttpServletRequest request, ModelMap model) {
        PaymentPlugins[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        PaymentPlugins[] paymentPluginsArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            PaymentPlugins bean = paymentPluginsArray[n2];
            log.info("delete Payment, id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(request, model);
    }

    @RequestMapping(value={"/plugins/o_priority.do"})
    public String priority(Long[] wids, Integer[] priority, Integer pageNo, HttpServletRequest request, ModelMap model) {
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(request, model);
    }

    private WebErrors validateSave(PaymentPlugins bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        PaymentPlugins entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, Payment.class, (Serializable)id);
    }
}

