/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Brand;
import com.jspgou.cms.entity.PopularityGroup;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductType;
import com.jspgou.cms.manager.BrandMng;
import com.jspgou.cms.manager.PopularityGroupMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ProductTypeMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class PopularityGroupAct {
    private static final Logger log = LoggerFactory.getLogger(PopularityGroupAct.class);
    @Autowired
    private BrandMng brandMng;
    @Autowired
    private ProductTypeMng productTypeMng;
    @Autowired
    private PopularityGroupMng manager;
    @Autowired
    private ProductMng productMng;

    @RequestMapping(value={"/popularityGroup/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return "popularityGroup/list";
    }

    @RequestMapping(value={"/popularityGroup/v_search.do"})
    public void update(Long typeId, Long brandId, String productName, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        List<Product> list = this.productMng.getList(typeId, brandId, productName);
        JSONObject json = new JSONObject();
        try {
            int i = 0;
            int j = list.size();
            while (i < j) {
                json.append("" + list.get(i).getId(), (Object)list.get(i).getName());
                ++i;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/popularityGroup/v_add.do"})
    public String add(ModelMap model) {
        List<ProductType> typeList = this.productTypeMng.getList(1L);
        List<Brand> brandList = this.brandMng.getAllList();
        model.addAttribute("brandList", brandList);
        model.addAttribute("typeList", typeList);
        return "popularityGroup/add";
    }

    @RequestMapping(value={"/popularityGroup/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        List<ProductType> typeList = this.productTypeMng.getList(1L);
        List<Brand> brandList = this.brandMng.getAllList();
        model.addAttribute("brandList", brandList);
        model.addAttribute("typeList", typeList);
        model.addAttribute("popularityGroup", (Object)this.manager.findById(id));
        return "popularityGroup/edit";
    }

    @RequestMapping(value={"/popularityGroup/o_save.do"})
    public String save(PopularityGroup bean, String rightlist, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        this.manager.addProduct(bean, this.getProductIds(rightlist));
        log.info("save PopularityGroup id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/popularityGroup/o_update.do"})
    public String update(PopularityGroup bean, String rightlist, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        this.manager.updateProduct(bean, this.getProductIds(rightlist));
        log.info("update PopularityGroup id={}.", (Object)bean.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/popularityGroup/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        PopularityGroup[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        PopularityGroup[] popularityGroupArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            PopularityGroup bean = popularityGroupArray[n2];
            log.info("delete PopularityGroup id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    public Long[] getProductIds(String rightlist) {
        String[] arr = rightlist.split(",");
        Long[] productIds = new Long[arr.length];
        int i = 0;
        int j = arr.length;
        while (i < j) {
            if (!arr[i].equals("")) {
                productIds[i] = Long.parseLong(arr[i]);
            }
            ++i;
        }
        return productIds;
    }

    private WebErrors validateSave(PopularityGroup bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        PopularityGroup entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, PopularityGroup.class, (Serializable)id);
    }
}

