/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Category;
import com.jspgou.cms.entity.Exended;
import com.jspgou.cms.entity.ExendedItem;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductExended;
import com.jspgou.cms.entity.ProductExt;
import com.jspgou.cms.entity.ProductFashion;
import com.jspgou.cms.entity.ProductStandard;
import com.jspgou.cms.entity.ProductType;
import com.jspgou.cms.entity.ProductTypeProperty;
import com.jspgou.cms.entity.Standard;
import com.jspgou.cms.entity.StandardType;
import com.jspgou.cms.lucene.LuceneProductSvc;
import com.jspgou.cms.manager.CartItemMng;
import com.jspgou.cms.manager.CategoryMng;
import com.jspgou.cms.manager.ExendedMng;
import com.jspgou.cms.manager.ProductFashionMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ProductStandardMng;
import com.jspgou.cms.manager.ProductTagMng;
import com.jspgou.cms.manager.ProductTypeMng;
import com.jspgou.cms.manager.ProductTypePropertyMng;
import com.jspgou.cms.manager.StandardMng;
import com.jspgou.cms.manager.StandardTypeMng;
import com.jspgou.common.image.ImageUtils;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.LockObtainFailedException;
import org.hibernate.ObjectNotFoundException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ProductAct
implements ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(ProductAct.class);
    @Autowired
    private StandardMng standardMng;
    @Autowired
    private StandardTypeMng standardTypeMng;
    @Autowired
    private ProductFashionMng fashMng;
    @Autowired
    private LuceneProductSvc luceneProductSvc;
    @Autowired
    private ProductTagMng productTagMng;
    @Autowired
    private CategoryMng categoryMng;
    @Autowired
    private ProductMng manager;
    @Autowired
    private ProductTypePropertyMng productTypePropertyMng;
    @Autowired
    private ProductFashionMng productFashionMng;
    @Autowired
    private ProductTypeMng productTypeMng;
    @Autowired
    private ExendedMng exendedMng;
    @Autowired
    private ProductStandardMng productStandardMng;
    @Autowired
    private CartItemMng cartItemMng;
    private ServletContext servletContext;

    @RequestMapping(value={"/product/v_list.do"})
    public String list(Long ctgId, Boolean isOnSale, Boolean isRecommend, Boolean isSpecial, Boolean isHotsale, Boolean isNewProduct, Long typeId, Double startSalePrice, Double endSalePrice, Integer startStock, Integer endStock, Integer pageNo, HttpServletRequest request, ModelMap model) {
        String productName = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"productName");
        productName = StringUtils.trim((String)productName);
        String brandName = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"brandName");
        brandName = StringUtils.trim((String)brandName);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (ctgId != null) {
            model.addAttribute("category", (Object)this.categoryMng.findById(ctgId));
        }
        Pagination pagination = this.manager.getPage(SiteUtils.getWebId((HttpServletRequest)request), ctgId, productName, brandName, isOnSale, isRecommend, isSpecial, isHotsale, isNewProduct, typeId, startSalePrice, endSalePrice, startStock, endStock, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        List<ProductType> typeList = this.productTypeMng.getList(web.getId());
        model.addAttribute("typeList", typeList);
        model.addAttribute("productName", (Object)productName);
        model.addAttribute("brandName", (Object)brandName);
        model.addAttribute("isOnSale", (Object)isOnSale);
        model.addAttribute("isRecommend", (Object)isRecommend);
        model.addAttribute("isSpecial", (Object)isSpecial);
        model.addAttribute("isHotsale", (Object)isHotsale);
        model.addAttribute("isNewProduct", (Object)isNewProduct);
        model.addAttribute("typeId", (Object)typeId);
        model.addAttribute("startSalePrice", (Object)startSalePrice);
        model.addAttribute("endSalePrice", (Object)endSalePrice);
        model.addAttribute("startStock", (Object)startStock);
        model.addAttribute("endStock", (Object)endStock);
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("ctgId", (Object)ctgId);
        return "product/list";
    }

    @RequestMapping(value={"/product/v_left.do"})
    public String left(HttpServletRequest request, ModelMap model) {
        List<Category> list = this.categoryMng.getTopList(SiteUtils.getWebId((HttpServletRequest)request));
        if (list.size() > 0) {
            Category treeRoot = new Category();
            treeRoot.setName(MessageResolver.getMessage((HttpServletRequest)request, (String)"product.allCategory", (Object[])new Object[0]));
            treeRoot.setChild(new LinkedHashSet<Category>(list));
            model.addAttribute("treeRoot", (Object)treeRoot);
        }
        return "product/left";
    }

    @RequestMapping(value={"/product/v_add.do"})
    public String add(Long ctgId, HttpServletRequest request, ModelMap model) {
        Category category = this.categoryMng.findById(ctgId);
        List<ProductTypeProperty> itemList = this.productTypePropertyMng.getList(category.getType().getId(), false);
        List<StandardType> standardTypeList = this.standardTypeMng.getList((Long)category.getId());
        model.addAttribute("ctgId", (Object)ctgId);
        model.addAttribute("category", (Object)category);
        model.addAttribute("categoryList", this.categoryMng.getListForProduct(SiteUtils.getWebId((HttpServletRequest)request), ctgId));
        model.addAttribute("tagList", this.productTagMng.getList(SiteUtils.getWebId((HttpServletRequest)request)));
        model.addAttribute("standardTypeList", standardTypeList);
        model.addAttribute("itemList", itemList);
        List<Exended> exendeds = this.exendedMng.getList(category.getType().getId());
        HashMap<String, Set<ExendedItem>> map = new HashMap<String, Set<ExendedItem>>();
        HashMap<String, Exended> map1 = new HashMap<String, Exended>();
        int num = exendeds.size();
        int i = 0;
        while (i < num) {
            map.put(exendeds.get(i).getId().toString(), exendeds.get(i).getItems());
            map1.put(exendeds.get(i).getId().toString(), exendeds.get(i));
            ++i;
        }
        model.addAttribute("map", map);
        model.addAttribute("map1", map1);
        return "product/add";
    }

    @RequestMapping(value={"/product/v_edit.do"})
    public String edit(Long id, Long ctgId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Product product = this.manager.findById(id);
        List<ProductStandard> psList = this.productStandardMng.findByProductId(id);
        String productKeywords = StringUtils.join(product.getKeywords(), (String)",");
        Category category = product.getCategory();
        List<StandardType> standardTypeList = this.standardTypeMng.getList((Long)category.getId());
        List<ProductTypeProperty> itemList = this.productTypePropertyMng.getList(category.getType().getId(), false);
        List<ProductExended> pelist = product.getExendeds();
        List<Exended> exendeds = this.exendedMng.getList(category.getType().getId());
        HashMap<String, Set<ExendedItem>> map = new HashMap<String, Set<ExendedItem>>();
        HashMap<String, Exended> map1 = new HashMap<String, Exended>();
        int num = exendeds.size();
        int i = 0;
        while (i < num) {
            map.put(exendeds.get(i).getId().toString(), exendeds.get(i).getItems());
            map1.put(exendeds.get(i).getId().toString(), exendeds.get(i));
            ++i;
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        int i2 = 0;
        while (i2 < pelist.size()) {
            map2.put(pelist.get(i2).getName(), pelist.get(i2).getValue());
            ++i2;
        }
        model.addAttribute("map2", map2);
        model.addAttribute("map", map);
        model.addAttribute("map1", map1);
        model.addAttribute("productKeywords", (Object)productKeywords);
        model.addAttribute("tagList", this.productTagMng.getList(SiteUtils.getWebId((HttpServletRequest)request)));
        model.addAttribute("categoryList", this.categoryMng.getList(SiteUtils.getWebId((HttpServletRequest)request)));
        model.addAttribute("standardTypeList", standardTypeList);
        model.addAttribute("category", (Object)category);
        model.addAttribute("product", (Object)product);
        model.addAttribute("ctgId", (Object)ctgId);
        model.addAttribute("isLimit", (Object)product.getProductExt().getIslimitTime());
        model.addAttribute("itemList", itemList);
        model.addAttribute("psList", psList);
        return "product/edit";
    }

    @RequestMapping(value={"/product/o_save.do"})
    public String save(Product bean, ProductExt ext, Long categoryId, Long brandId, Long[] tagIds, String productKeywords, String[] nature, Long[] picture, String[] colorImg, Long[] character, @RequestParam(value="file", required=false) MultipartFile file, String[] fashionSwitchPic, String[] fashionBigPic, String[] fashionAmpPic, Boolean[] isDefaults, Long[] colors, Long[] measures, Integer[] stockCounts, Double[] salePrices, Double[] marketPrices, Double[] costPrices, Long ctgId, HttpServletRequest request, ModelMap model) {
        ProductStandard ps;
        WebErrors errors = this.validateSave(bean, file, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        productKeywords = StringUtils.replace((String)productKeywords, (String)MessageResolver.getMessage((HttpServletRequest)request, (String)"product.keywords.split", (Object[])new Object[0]), (String)",");
        String[] keywords = StringUtils.split((String)productKeywords, (String)",");
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        Map exended = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"exended_");
        ArrayList li = new ArrayList(exended.keySet());
        String[] names = new String[li.size()];
        String[] values = new String[li.size()];
        if (stockCounts != null) {
            Integer stockCount = 0;
            Integer[] integerArray = stockCounts;
            int n = stockCounts.length;
            int n2 = 0;
            while (n2 < n) {
                Integer s = integerArray[n2];
                stockCount = stockCount + s;
                ++n2;
            }
            bean.setStockCount(stockCount);
        }
        int i = 0;
        while (i < li.size()) {
            names[i] = (String)li.get(i);
            values[i] = (String)exended.get(li.get(i));
            ++i;
        }
        bean.setAttr(RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_"));
        bean = this.manager.save(bean, ext, web.getId(), categoryId, brandId, tagIds, keywords, names, values, fashionSwitchPic, fashionBigPic, fashionAmpPic, file);
        if (picture != null) {
            i = 0;
            while (i < picture.length) {
                ps = new ProductStandard();
                ps.setImgPath(colorImg[i]);
                ps.setType(this.standardMng.findById(picture[i]).getType());
                ps.setProduct(bean);
                ps.setStandard(this.standardMng.findById(picture[i]));
                ps.setDataType(true);
                this.productStandardMng.save(ps);
                ++i;
            }
        }
        if (character != null) {
            i = 0;
            while (i < character.length) {
                ps = new ProductStandard();
                ps.setType(this.standardMng.findById(character[i]).getType());
                ps.setProduct(bean);
                ps.setStandard(this.standardMng.findById(character[i]));
                ps.setDataType(false);
                this.productStandardMng.save(ps);
                ++i;
            }
        }
        this.saveProductFash(bean, nature, isDefaults, stockCounts, salePrices, marketPrices, costPrices);
        log.info("save Product. id={}", (Object)bean.getId());
        model.addAttribute("message", (Object)"global.success");
        model.addAttribute("brandId", (Object)brandId);
        return this.add(ctgId, request, model);
    }

    @RequestMapping(value={"/product/o_update.do"})
    public String update(Product bean, ProductExt ext, Long categoryId, Long brandId, Long[] tagIds, String productKeywords, String[] nature, Long[] picture, String[] colorImg, Long[] character, @RequestParam(value="file", required=false) MultipartFile file, String[] fashionSwitchPic, String[] fashionBigPic, String[] fashionAmpPic, Boolean[] isDefaults, Long[] colors, Long[] measures, Integer[] stockCounts, Double[] salePrices, Double[] marketPrices, Double[] costPrices, Long[] fashId, Long ctgId, Integer pageNo, HttpServletRequest request, ModelMap model) {
        block16: {
            int i;
            WebErrors errors = this.validateUpdate(bean.getId(), file, request);
            if (errors.hasErrors()) {
                return errors.showErrorPage(model);
            }
            productKeywords = StringUtils.replace((String)productKeywords, (String)MessageResolver.getMessage((HttpServletRequest)request, (String)"product.keywords.split", (Object[])new Object[0]), (String)",");
            String[] keywords = StringUtils.split((String)productKeywords, (String)",");
            Map exended = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"exended_");
            ArrayList li = new ArrayList(exended.keySet());
            String[] names = new String[li.size()];
            String[] values = new String[li.size()];
            int i2 = 0;
            while (i2 < li.size()) {
                names[i2] = (String)li.get(i2);
                values[i2] = (String)exended.get(li.get(i2));
                ++i2;
            }
            Map attr = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"attr_");
            if (stockCounts != null) {
                Integer stockCount = 0;
                Integer[] integerArray = stockCounts;
                int n = stockCounts.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer s = integerArray[n2];
                    stockCount = stockCount + s;
                    ++n2;
                }
                bean.setStockCount(stockCount);
            }
            bean = this.manager.update(bean, ext, categoryId, brandId, tagIds, keywords, names, values, attr, fashionSwitchPic, fashionBigPic, fashionAmpPic, file);
            List<ProductStandard> pcList = this.productStandardMng.findByProductId(bean.getId());
            int j = 0;
            while (j < pcList.size()) {
                this.productStandardMng.deleteById(pcList.get(j).getId());
                ++j;
            }
            if (picture != null) {
                i = 0;
                while (i < picture.length) {
                    ProductStandard ps = new ProductStandard();
                    ps.setImgPath(colorImg[i]);
                    ps.setType(this.standardMng.findById(picture[i]).getType());
                    ps.setProduct(bean);
                    ps.setStandard(this.standardMng.findById(picture[i]));
                    ps.setDataType(true);
                    this.productStandardMng.save(ps);
                    ++i;
                }
            }
            if (character != null) {
                i = 0;
                while (i < character.length) {
                    ProductStandard ps = new ProductStandard();
                    ps.setType(this.standardMng.findById(character[i]).getType());
                    ps.setProduct(bean);
                    ps.setStandard(this.standardMng.findById(character[i]));
                    ps.setDataType(false);
                    this.productStandardMng.save(ps);
                    ++i;
                }
            }
            try {
                if (!bean.getCategory().getColorsize().booleanValue()) break block16;
                Set<ProductFashion> pfList = bean.getFashions();
                if (fashId != null) {
                    for (ProductFashion ps : pfList) {
                        if (Arrays.asList(fashId).contains(ps.getId())) continue;
                        this.fashMng.deleteById(ps.getId());
                        this.cartItemMng.deleteByProductFactionId(ps.getId());
                    }
                } else {
                    for (ProductFashion ps : pfList) {
                        this.fashMng.deleteById(ps.getId());
                        this.cartItemMng.deleteByProductFactionId(ps.getId());
                    }
                }
                this.updateProductFash(bean, fashId, nature, isDefaults, stockCounts, salePrices, marketPrices, costPrices);
            }
            catch (ObjectNotFoundException pfList) {
            }
            catch (Exception e) {
                errors.addErrorString(this.manager.getTipFile("This.ChangeIsContainedInTheCaseOfTheDeletionOfTheGoods"));
                return errors.showErrorPage(model);
            }
        }
        log.info("update Product. id={}.", (Object)bean.getId());
        return this.list(ctgId, null, null, null, null, null, null, null, null, null, null, pageNo, request, model);
    }

    @RequestMapping(value={"/product/o_delete.do"})
    public String delete(Long[] ids, Long ctgId, Boolean isRecommend, Boolean isSpecial, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            Product[] beans;
            Product[] productArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                Product bean = productArray[n2];
                log.info("delete Product. id={}", (Object)bean.getId());
                ++n2;
            }
        }
        catch (Exception e) {
            return "redirect:v_error.do";
        }
        return this.list(ctgId, null, isRecommend, isSpecial, null, null, null, null, null, null, null, pageNo, request, model);
    }

    @RequestMapping(value={"/product/v_error.do"})
    public String error(HttpServletRequest request, ModelMap model) {
        return "product/error";
    }

    @RequestMapping(value={"/product/v_standardTypes_add.do"})
    public String standardTypesAdd(Long categoryId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        List<StandardType> standardTypeList = this.standardTypeMng.getList(categoryId);
        model.addAttribute("standardTypeList", standardTypeList);
        model.addAttribute("digit", (Object)standardTypeList.size());
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/json;charset=UTF-8");
        return "product/standardTypes_add";
    }

    @RequestMapping(value={"/product/v_standards_add.do"})
    public String standards(Long standardTypeId, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        List<Standard> sList = this.standardMng.findByTypeId(standardTypeId);
        model.addAttribute("sList", sList);
        model.addAttribute("standardType", (Object)this.standardTypeMng.findById(standardTypeId));
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/json;charset=UTF-8");
        return "product/standards_add";
    }

    @RequestMapping(value={"/product/o_create_index.do"})
    public String createIndex(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        String path = this.servletContext.getRealPath("/WEB-INF/lucene");
        boolean success = false;
        try {
            int count = this.luceneProductSvc.index(path, null, null, null);
            model.addAttribute("count", (Object)count);
            success = true;
        }
        catch (CorruptIndexException e) {
            log.error("", (Throwable)e);
        }
        catch (LockObtainFailedException e) {
            log.error("", (Throwable)e);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        model.addAttribute("success", (Object)success);
        return "product/create_index_result";
    }

    @RequestMapping(value={"/product/o_delFashion.do"})
    public String deleFashion(Long id, Long productId, HttpServletResponse response) throws JSONException {
        Boolean b = this.productFashionMng.getOneFash(productId);
        JSONObject j = new JSONObject();
        if (b != null && b.booleanValue()) {
            this.productFashionMng.deleteById(id);
            j.put("message", (Object)"\u5220\u9664\u6210\u529f\uff01");
            j.put("boo", true);
            ResponseUtils.renderJson((HttpServletResponse)response, (String)j.toString());
            return null;
        }
        j.put("message", (Object)"\u5fc5\u987b\u7559\u4e00\u6b3e\u5f0f\uff01");
        j.put("boo", false);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)j.toString());
        return null;
    }

    private void saveProductFash(Product bean, String[] nature, Boolean[] isDefaults, Integer[] stockCounts, Double[] salePrices, Double[] marketPrices, Double[] costPrices) {
        if (nature != null) {
            int i = 0;
            while (i < nature.length) {
                ProductFashion pfash = new ProductFashion();
                pfash.setCreateTime(new Date());
                pfash.setIsDefault(isDefaults[i]);
                pfash.setStockCount(stockCounts[i]);
                pfash.setMarketPrice(marketPrices[i]);
                pfash.setSalePrice(salePrices[i]);
                pfash.setCostPrice(costPrices[i]);
                pfash.setProductId(bean);
                pfash.setNature(nature[i]);
                String[] arr = nature[i].split("_");
                ProductFashion fashion = this.productFashionMng.save(pfash, arr);
                this.productFashionMng.addStandard(fashion, arr);
                if (isDefaults[i].booleanValue()) {
                    bean.setCostPrice(costPrices[i]);
                    bean.setMarketPrice(marketPrices[i]);
                    bean.setSalePrice(salePrices[i]);
                    this.manager.update(bean);
                }
                ++i;
            }
        }
    }

    private void updateProductFash(Product bean, Long[] fashId, String[] nature, Boolean[] isDefaults, Integer[] stockCounts, Double[] salePrices, Double[] marketPrices, Double[] costPrices) {
        if (nature != null) {
            int i = 0;
            while (i < nature.length) {
                String[] arr;
                ProductFashion pfash;
                if (fashId != null && i < fashId.length) {
                    pfash = this.productFashionMng.findById(fashId[i]);
                    pfash.setCreateTime(new Date());
                    pfash.setIsDefault(isDefaults[i]);
                    pfash.setStockCount(stockCounts[i]);
                    pfash.setMarketPrice(marketPrices[i]);
                    pfash.setSalePrice(salePrices[i]);
                    pfash.setCostPrice(costPrices[i]);
                    pfash.setProductId(bean);
                    pfash.setNature(nature[i]);
                    arr = nature[i].split("_");
                    this.productFashionMng.updateStandard(pfash, arr);
                    if (isDefaults[i].booleanValue()) {
                        bean.setCostPrice(costPrices[i]);
                        bean.setMarketPrice(marketPrices[i]);
                        bean.setSalePrice(salePrices[i]);
                        this.manager.update(bean);
                    }
                } else {
                    pfash = new ProductFashion();
                    pfash.setCreateTime(new Date());
                    pfash.setIsDefault(isDefaults[i]);
                    pfash.setStockCount(stockCounts[i]);
                    pfash.setMarketPrice(marketPrices[i]);
                    pfash.setSalePrice(salePrices[i]);
                    pfash.setCostPrice(costPrices[i]);
                    pfash.setProductId(bean);
                    pfash.setNature(nature[i]);
                    arr = nature[i].split("_");
                    ProductFashion fashion = this.productFashionMng.save(pfash, arr);
                    this.productFashionMng.addStandard(fashion, arr);
                    if (isDefaults[i].booleanValue()) {
                        bean.setCostPrice(costPrices[i]);
                        bean.setMarketPrice(marketPrices[i]);
                        bean.setSalePrice(salePrices[i]);
                        this.manager.update(bean);
                    }
                }
                ++i;
            }
        }
    }

    private WebErrors validateSave(Product bean, MultipartFile file, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (file != null && !file.isEmpty()) {
            String name = file.getOriginalFilename();
            this.vldImage(name, errors);
        }
        bean.setWebsite(SiteUtils.getWeb((HttpServletRequest)request));
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateUpdate(Long id, MultipartFile file, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        if (file != null && !file.isEmpty()) {
            String name = file.getOriginalFilename();
            this.vldImage(name, errors);
            if (errors.hasErrors()) {
                return errors;
            }
        }
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private void vldExist(Long id, WebErrors errors) {
        if (errors.hasErrors()) {
            return;
        }
        Product entity = this.manager.findById(id);
        errors.ifNotExist((Object)entity, Product.class, (Serializable)id);
    }

    private void vldImage(String filename, WebErrors errors) {
        if (errors.hasErrors()) {
            return;
        }
        String ext = FilenameUtils.getExtension((String)filename);
        if (!ImageUtils.isImage((String)ext)) {
            errors.addErrorString("not support image extension:" + filename);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

