/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Product;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.core.entity.Global;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ProductStatisticsAct {
    @Autowired
    private ProductMng productMng;

    @RequestMapping(value={"/productStatistics/v_productLack.do"})
    public String productLack(Integer count, Boolean status, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        Global global = web.getGlobal();
        if (count == null) {
            count = global.getStockWarning();
        }
        Pagination pagination = this.productMng.getPageByStockWarning(web.getId(), count, status, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("count", (Object)count);
        model.addAttribute("status", (Object)status);
        return "sale/productLack";
    }

    @RequestMapping(value={"/productStatistics/o_updateRemind.do"})
    public String updateRemind(Boolean status, Integer count, Integer pageNo, Long productId, HttpServletRequest request, ModelMap model) {
        Product product = this.productMng.findById(productId);
        product.setLackRemind(status);
        this.productMng.updateByUpdater(product);
        status = status != false ? Boolean.valueOf(false) : Boolean.valueOf(true);
        model.addAttribute("status", (Object)status);
        model.addAttribute("count", (Object)count);
        return "redirect:v_productLack.do";
    }

    @RequestMapping(value={"/productStatistics/o_resetSaleTop.do"})
    public String resetSaleTop(Integer pageNo, HttpServletRequest request, ModelMap model) {
        this.productMng.resetSaleTop();
        return this.productSaleTop(pageNo, request, model);
    }

    @RequestMapping(value={"/productStatistics/v_productSaleTop.do"})
    public String productSaleTop(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.productMng.getPage(4, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pageNo);
        return "sale/productSaleTop";
    }

    @RequestMapping(value={"/productStatistics/o_resetProfitTop.do"})
    public String resetProfitTop(Integer pageNo, HttpServletRequest request, ModelMap model) {
        this.productMng.resetProfitTop();
        return this.productProfitTop(pageNo, request, model);
    }

    @RequestMapping(value={"/productStatistics/v_productProfitTop.do"})
    public String productProfitTop(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.productMng.getPage(8, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pageNo);
        return "sale/productProfitTop";
    }
}

