/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.ProductTag;
import com.jspgou.cms.manager.ProductTagMng;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ProductTagAct {
    private static final Logger log = LoggerFactory.getLogger(ProductTagAct.class);
    @Autowired
    private ProductTagMng manager;

    @RequestMapping(value={"/tag/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        List<ProductTag> list = this.manager.getList(SiteUtils.getWebId((HttpServletRequest)request));
        model.addAttribute("list", list);
        return "tag/list";
    }

    @RequestMapping(value={"/tag/o_save.do"})
    public String save(ProductTag bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save ProductTag. id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/tag/o_update_tag_names.do"})
    public String updateTagName(Long[] wids, String[] tagNames, HttpServletRequest request, ModelMap model) {
        ProductTag[] beans;
        WebErrors errors = this.validateUpdateTagNames(wids, tagNames, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        ProductTag[] productTagArray = beans = this.manager.updateTagName(wids, tagNames);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            ProductTag bean = productTagArray[n2];
            log.info("update ProductTag. id={},name={}", (Object)bean.getId(), (Object)bean.getName());
            ++n2;
        }
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/tag/o_delete.do"})
    public String delete(Long[] ids, HttpServletRequest request, ModelMap model) {
        ProductTag[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        ProductTag[] productTagArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            ProductTag bean = productTagArray[n2];
            log.info("delete ProductTag. id={},name={}", (Object)bean.getId(), (Object)bean.getName());
            ++n2;
        }
        return this.list(request, model);
    }

    private WebErrors validateSave(ProductTag bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        bean.setWebsite(SiteUtils.getWeb((HttpServletRequest)request));
        return errors;
    }

    private WebErrors validateUpdateTagNames(Long[] wids, String[] tagNames, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])wids, "wids");
        errors.ifEmpty((Object[])tagNames, "tagNames");
        if (errors.hasErrors()) {
            return errors;
        }
        if (wids.length != tagNames.length) {
            errors.addErrorString("wids length must equals tagNames length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            this.vldExist(wids[i], errors);
            if (errors.hasErrors()) {
                return errors;
            }
            ++i;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private void vldExist(Long id, WebErrors errors) {
        if (errors.hasErrors()) {
            return;
        }
        ProductTag entity = this.manager.findById(id);
        errors.ifNotExist((Object)entity, ProductTag.class, (Serializable)id);
    }
}

