/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.ProductType;
import com.jspgou.cms.manager.BrandMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ProductTypeMng;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ProductTypeAct {
    private static final Logger log = LoggerFactory.getLogger(ProductTypeAct.class);
    @Autowired
    private BrandMng brandMng;
    @Autowired
    private ProductTypeMng manager;
    @Autowired
    private ProductMng productMng;

    @RequestMapping(value={"/type/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        List<ProductType> list = this.manager.getList(SiteUtils.getWebId((HttpServletRequest)request));
        model.addAttribute("list", list);
        return "type/list";
    }

    @RequestMapping(value={"/type/v_add.do"})
    public String add(ModelMap model) {
        return "type/add";
    }

    @RequestMapping(value={"/type/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("productType", (Object)this.manager.findById(id));
        return "type/edit";
    }

    @RequestMapping(value={"/type/o_save.do"})
    public String save(ProductType bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save ProductType. id={}", (Object)bean.getId());
        return this.list(request, model);
    }

    @RequestMapping(value={"/type/o_update.do"})
    public String update(ProductType bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update ProductType. id={}.", (Object)bean.getId());
        return this.list(request, model);
    }

    @RequestMapping(value={"/type/o_delete.do"})
    public String delete(Long[] ids, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            ProductType[] beans;
            ProductType[] productTypeArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                ProductType bean = productTypeArray[n2];
                log.info("delete ProductType. id={}", (Object)bean.getId());
                ++n2;
            }
        }
        catch (Exception e) {
            errors.addErrorString(this.productMng.getTipFile("Please.delete.the.classification.and.other.related.data"));
            return errors.showErrorPage(model);
        }
        return this.list(request, model);
    }

    private WebErrors validateSave(ProductType bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        bean.setWebsite(SiteUtils.getWeb((HttpServletRequest)request));
        return errors;
    }

    public WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    public WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private void vldExist(Long id, WebErrors errors) {
        if (errors.hasErrors()) {
            return;
        }
        ProductType entity = this.manager.findById(id);
        errors.ifNotExist((Object)entity, ProductType.class, (Serializable)id);
    }
}

