/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.ProductType;
import com.jspgou.cms.entity.ProductTypeProperty;
import com.jspgou.cms.manager.ProductTypeMng;
import com.jspgou.cms.manager.ProductTypePropertyMng;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ProductTypePropertyAct {
    private static final Logger log = LoggerFactory.getLogger(ProductTypePropertyAct.class);
    @Autowired
    private ProductTypePropertyMng manager;
    @Autowired
    private ProductTypeMng productTypeMng;

    @RequestMapping(value={"/typeProperty/v_list.do"})
    public String list(Long typeId, Boolean isCategory, HttpServletRequest request, ModelMap model) {
        ProductType pType = this.productTypeMng.findById(typeId);
        List<ProductTypeProperty> list = this.manager.getList(typeId, isCategory);
        model.addAttribute("list", list);
        model.addAttribute("typeId", (Object)typeId);
        model.addAttribute("isCategory", (Object)isCategory);
        model.addAttribute("fieldList", this.getFieldList(list));
        model.addAttribute("pType", (Object)pType);
        if (isCategory.booleanValue()) {
            return "typeProperty/list_category";
        }
        return "typeProperty/list_product";
    }

    @RequestMapping(value={"/typeProperty/v_add.do"})
    public String add(Long typeId, Boolean isCategory, HttpServletRequest request, ModelMap model) {
        ProductTypeProperty property = this.manager.findById(typeId);
        model.addAttribute("property", (Object)property);
        model.addAttribute("typeId", (Object)typeId);
        model.addAttribute("isCategory", (Object)isCategory);
        return "typeProperty/add";
    }

    @RequestMapping(value={"/typeProperty/v_edit.do"})
    public String delete(Long id, Integer pageNo, HttpServletRequest request, ModelMap model) {
        ProductTypeProperty property = this.manager.findById(id);
        model.addAttribute("property", (Object)property);
        model.addAttribute("typeId", (Object)property.getPropertyType().getId());
        model.addAttribute("isCategory", (Object)property.getCategory());
        return "typeProperty/edit";
    }

    @RequestMapping(value={"/typeProperty/o_save_list.do"})
    public String saveList(Long typeId, Boolean isCategory, String[] fields, String[] propertyNames, Integer[] dataTypes, Integer[] sorts, Boolean[] singles, HttpServletRequest request, ModelMap model) {
        ProductType pType = this.productTypeMng.findById(typeId);
        List<ProductTypeProperty> itemList = this.getItems(pType, isCategory, fields, propertyNames, dataTypes, sorts, singles);
        this.manager.saveList(itemList);
        log.info("save CmsModelItem count={}", (Object)itemList.size());
        model.addAttribute("typeId", (Object)typeId);
        model.addAttribute("isCategory", (Object)isCategory);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/typeProperty/o_save.do"})
    public String save(ProductTypeProperty bean, Long typeId, HttpServletRequest request, ModelMap model) {
        ProductType type = new ProductType();
        type.setId(typeId);
        bean.setPropertyType(type);
        bean.setSingle(true);
        bean.setCustom(true);
        this.manager.save(bean);
        model.addAttribute("typeId", (Object)typeId);
        model.addAttribute("isCategory", (Object)bean.getCategory());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/typeProperty/o_update.do"})
    public String update(ProductTypeProperty bean, Long typeId, boolean category, HttpServletRequest request, ModelMap model) {
        this.manager.update(bean);
        model.addAttribute("typeId", (Object)typeId);
        model.addAttribute("isCategory", (Object)category);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/typeProperty/o_priority.do"})
    public String priority(Long[] wids, Integer[] sort, String[] propertyName, Boolean[] single, Long typeId, Boolean isCategory, HttpServletRequest request, ModelMap model) {
        if (wids != null && wids.length > 0) {
            this.manager.updatePriority(wids, sort, propertyName, single);
        }
        model.addAttribute("message", (Object)"global.success");
        return this.list(typeId, isCategory, request, model);
    }

    @RequestMapping(value={"/typeProperty/o_delete.do"})
    public String delete(Long[] ids, Integer typeId, Boolean isCategory, HttpServletRequest request, ModelMap model) {
        ProductTypeProperty[] beans;
        ProductTypeProperty[] productTypePropertyArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            ProductTypeProperty bean = productTypePropertyArray[n2];
            log.info("delete CmsModelItem id={}", (Object)bean.getId());
            ++n2;
        }
        model.addAttribute("typeId", (Object)typeId);
        model.addAttribute("isCategory", (Object)isCategory);
        return "redirect:v_list.do";
    }

    private List<String> getFieldList(List<ProductTypeProperty> items) {
        ArrayList<String> list = new ArrayList<String>(items.size());
        for (ProductTypeProperty item : items) {
            list.add(item.getField());
        }
        return list;
    }

    private List<ProductTypeProperty> getItems(ProductType model, boolean isCategory, String[] fields, String[] propertyNames, Integer[] dataTypes, Integer[] sorts, Boolean[] singles) {
        ArrayList<ProductTypeProperty> list = new ArrayList<ProductTypeProperty>();
        int i = 0;
        int len = fields.length;
        while (i < len) {
            if (!StringUtils.isBlank((String)fields[i])) {
                ProductTypeProperty item = new ProductTypeProperty();
                item.setCustom(false);
                item.setPropertyType(model);
                item.setCategory(isCategory);
                item.setField(fields[i]);
                item.setPropertyName(propertyNames[i]);
                item.setSort(sorts[i]);
                item.setDataType(dataTypes[i]);
                item.setSingle(singles[i]);
                list.add(item);
            }
            ++i;
        }
        return list;
    }
}

