/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.manager.ResourceMng;
import com.jspgou.common.file.FileWrap;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.common.web.springmvc.RealPathResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.TemplateMng;
import com.jspgou.core.web.SiteUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
public class ResourceAct
implements ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(ResourceAct.class);
    private static final String REL_PATH = "relPath";
    private String root;
    @Autowired
    private TemplateMng manager;
    @Autowired
    private ResourceMng resourceMng;
    private ServletContext servletContext;
    private RealPathResolver realPathResolver;

    @RequestMapping(value={"/resource/v_left.do"})
    public String left(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String resReal = this.servletContext.getRealPath(web.getResBaseRel());
        String resName = MessageResolver.getMessage((HttpServletRequest)request, (String)"resource.resName", (Object[])new Object[0]);
        FileWrap wrap = this.manager.getResFileWrap(resReal, resName);
        model.addAttribute("treeRoot", (Object)wrap);
        return "resource/left";
    }

    @RequestMapping(value={"/resource/v_tree.do"})
    public String tree(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        log.debug("tree path={}", (Object)root);
        if (StringUtils.isBlank((String)root) || "source".equals(root)) {
            root = web.getResBaseRel();
            model.addAttribute("isRoot", (Object)true);
        } else {
            model.addAttribute("isRoot", (Object)false);
        }
        List<FileWrap> resList = this.resourceMng.listFile(root, true);
        model.addAttribute("resList", resList);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/json;charset=UTF-8");
        return "resource/tree";
    }

    @RequestMapping(value={"/resource/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        String rel;
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String root = (String)model.get((Object)"root");
        if (root == null) {
            root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        }
        log.debug("list Resource root: {}", (Object)root);
        if (StringUtils.isBlank((String)root)) {
            root = web.getResBaseRel();
        }
        if ((rel = root.substring(web.getResBaseRel().length())).length() == 0) {
            rel = "/";
        }
        model.addAttribute("root", (Object)root);
        model.addAttribute("rel", (Object)rel);
        model.addAttribute("resBase", (Object)web.getResBaseUrl());
        model.addAttribute("list", this.resourceMng.listFile(root, false));
        return "resource/list";
    }

    @RequestMapping(value={"/resource/o_create_dir.do"})
    public String createDir(String root, String dirName, HttpServletRequest request, ModelMap model) {
        this.resourceMng.createDir(root, dirName);
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/resource/v_rename.do"})
    public String renameInput(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        String origName = name.substring(web.getResBaseRel().length());
        model.addAttribute("origName", (Object)origName);
        model.addAttribute("root", (Object)root);
        return "resource/rename";
    }

    @RequestMapping(value={"/resource/o_rename.do"})
    public String renameUpdate(String relPath, String origName, String newName, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String real = this.servletContext.getRealPath(web.getResBaseRel(relPath));
        File origFile = new File(real, origName);
        File newFile = new File(real, newName);
        origFile.renameTo(newFile);
        log.info("rename resource dir {} to {}", (Object)origFile.getAbsolutePath(), (Object)newFile.getAbsolutePath());
        model.addAttribute(REL_PATH, (Object)relPath);
        return this.list(request, model);
    }

    @RequestMapping(value={"/resource/v_add.do"})
    public String add(String relPath, HttpServletRequest request, ModelMap model) {
        model.addAttribute(REL_PATH, (Object)relPath);
        return "resource/add";
    }

    @RequestMapping(value={"/resource/o_save.do"})
    public String save(String relPath, String filename, String extension, String content, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String real = this.servletContext.getRealPath(web.getResBaseRel(relPath));
        try {
            File file = new File(real, String.valueOf(filename) + extension);
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
            log.info("save resource file success: {}", (Object)file.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("write resource file error", (Throwable)e);
        }
        model.addAttribute(REL_PATH, (Object)relPath);
        return this.list(request, model);
    }

    @RequestMapping(value={"/resource/v_edit.do"})
    public String edit(HttpServletRequest request, ModelMap model) {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String real = this.servletContext.getRealPath(name);
        File file = new File(real);
        String filename = file.getName();
        try {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            model.addAttribute("content", (Object)content);
        }
        catch (IOException e) {
            log.error("read resource file error", (Throwable)e);
        }
        model.addAttribute("filename", (Object)filename);
        model.addAttribute("root", (Object)root);
        model.addAttribute("name", (Object)name);
        return "resource/edit";
    }

    @RequestMapping(value={"/resource/o_update.do"})
    public String update(String name, String content, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        String real = this.realPathResolver.get(name);
        File file = new File(real);
        try {
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        }
        catch (IOException e) {
            log.error("write resource file error", (Throwable)e);
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
        return null;
    }

    @RequestMapping(value={"/resource/o_delete.do"})
    public String delete(String relPath, String[] names, HttpServletRequest request, ModelMap model) {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            int count = this.resourceMng.delete(new String[]{name});
            log.info("delete Resource {}, count {}", (Object)name, (Object)count);
            ++n2;
        }
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/resource/o_delete_single.do"})
    public String deleteSingle(HttpServletRequest request, ModelMap model) {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        int count = this.resourceMng.delete(new String[]{name});
        log.info("delete Resource {}, count {}", (Object)name, (Object)count);
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/resource/v_upload.do"})
    public String uploadInput(String relPath, HttpServletRequest request, ModelMap model) {
        model.addAttribute(REL_PATH, (Object)relPath);
        return "resource/upload";
    }

    @RequestMapping(value={"/resource/o_upload.do"})
    public String uploadSubmit(String relPath, HttpServletRequest request, ModelMap model) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map map = multipartRequest.getFileMap();
        MultipartFile[] files = new MultipartFile[map.size()];
        map.values().toArray(files);
        if (files.length > 0) {
            Website web = SiteUtils.getWeb((HttpServletRequest)request);
            String realPath = this.servletContext.getRealPath(web.getResBaseRel(relPath));
            this.manager.uploadResourceFile(realPath, files);
        }
        model.addAttribute(REL_PATH, (Object)relPath);
        return this.list(request, model);
    }

    @RequestMapping(value={"/resource/o_swfupload.do"}, method={RequestMethod.POST})
    public void swfUpload(String root, @RequestParam(value="Filedata", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IllegalStateException, IOException {
        this.resourceMng.saveFile(root, file);
        model.addAttribute("root", (Object)root);
        log.info("file upload seccess: {}, size:{}.", (Object)file.getOriginalFilename(), (Object)file.getSize());
        ResponseUtils.renderText((HttpServletResponse)response, (String)"");
    }

    @Autowired
    public void setRealPathResolver(RealPathResolver realPathResolver) {
        this.realPathResolver = realPathResolver;
        this.root = realPathResolver.get("");
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

