/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.core.entity.Role;
import com.jspgou.core.manager.LogMng;
import com.jspgou.core.manager.RoleMng;
import com.jspgou.core.security.CmsAuthorizingRealm;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class RoleAct {
    private static final Logger log = LoggerFactory.getLogger(RoleAct.class);
    @Autowired
    private RoleMng manager;
    @Autowired
    private LogMng cmsLogMng;
    @Autowired
    private CmsAuthorizingRealm authorizingRealm;

    @RequestMapping(value={"/role/v_list.do"})
    public String list(HttpServletRequest request, ModelMap model) {
        List list = this.manager.getList();
        model.addAttribute("list", (Object)list);
        return "role/list";
    }

    @RequestMapping(value={"/role/v_add.do"})
    public String add(ModelMap model) {
        return "role/add";
    }

    @RequestMapping(value={"/role/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        model.addAttribute("role", (Object)this.manager.findById(id));
        return "role/edit";
    }

    @RequestMapping(value={"/role/o_save.do"})
    public String save(Role bean, String[] perms, HttpServletRequest request, ModelMap model) {
        bean = this.manager.save(bean, this.splitPerms(perms));
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/role/o_update.do"})
    public String update(Role bean, String[] perms, boolean all, HttpServletRequest request, ModelMap model) {
        bean = this.manager.update(bean, this.splitPerms(perms));
        return this.list(request, model);
    }

    @RequestMapping(value={"/role/o_delete.do"})
    public String delete(Integer[] ids, HttpServletRequest request, ModelMap model) {
        Role[] beans = this.manager.deleteByIds(ids);
        return this.list(request, model);
    }

    private Set<String> splitPerms(String[] perms) {
        HashSet<String> set = new HashSet<String>();
        if (perms != null) {
            String[] stringArray = perms;
            int n = perms.length;
            int n2 = 0;
            while (n2 < n) {
                String perm = stringArray[n2];
                String[] stringArray2 = StringUtils.split((String)perm, (char)',');
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String p = stringArray2[n4];
                    if (!StringUtils.isBlank((String)p)) {
                        set.add(p);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return set;
    }

    private boolean hasChangePermission(boolean all, String[] perms, Role bean) {
        Role role = this.manager.findById(bean.getId());
        return !bean.getPerms().toArray().equals(perms);
    }

    private WebErrors validateUpdate(Integer id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private boolean vldExist(Integer id, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        Role entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, Role.class, (Serializable)id);
    }
}

