/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Logistics;
import com.jspgou.cms.entity.Shipping;
import com.jspgou.cms.manager.LogisticsMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ShippingMng;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShippingAct {
    private static final Logger log = LoggerFactory.getLogger(ShippingAct.class);
    @Autowired
    private ProductMng productMng;
    @Autowired
    private ShippingMng manager;
    @Autowired
    private LogisticsMng logisticsMng;

    @RequestMapping(value={"/shipping/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        List<Shipping> list = this.manager.getList(SiteUtils.getWebId((HttpServletRequest)request), true);
        model.addAttribute("list", list);
        return "shipping/list";
    }

    @RequestMapping(value={"/shipping/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        List<Logistics> list = this.logisticsMng.getAllList();
        model.addAttribute("list", list);
        return "shipping/add";
    }

    @RequestMapping(value={"/shipping/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("shipping", (Object)this.manager.findById(id));
        List<Logistics> list = this.logisticsMng.getAllList();
        model.addAttribute("list", list);
        return "shipping/edit";
    }

    @RequestMapping(value={"/shipping/o_save.do"})
    public String save(Shipping bean, Long logisticsId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        if (bean.getIsDefault().booleanValue()) {
            List<Shipping> list = this.manager.getList(1L, true);
            int i = 0;
            while (i < list.size()) {
                list.get(i).setIsDefault(false);
                this.manager.update(list.get(i));
                ++i;
            }
        }
        bean.setLogistics(this.logisticsMng.findById(logisticsId));
        bean = this.manager.save(bean);
        log.info("save Shipping. id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/shipping/o_update.do"})
    public String update(Shipping bean, Long logisticsId, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        if (bean.getIsDefault().booleanValue()) {
            List<Shipping> list = this.manager.getList(1L, true);
            int i = 0;
            while (i < list.size()) {
                list.get(i).setIsDefault(false);
                this.manager.update(bean);
                ++i;
            }
        }
        bean.setLogistics(this.logisticsMng.findById(logisticsId));
        bean = this.manager.update(bean);
        log.info("update Shipping. id={}.", (Object)bean.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/shipping/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            Shipping[] beans;
            Shipping[] shippingArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                Shipping bean = shippingArray[n2];
                log.info("delete Shipping. id={}", (Object)bean.getId());
                ++n2;
            }
        }
        catch (Exception e) {
            errors.addErrorString(this.productMng.getTipFile("delete.shipping"));
            return errors.showErrorPage(model);
        }
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/shipping/o_priority.do"})
    public String priority(Long[] wids, Integer[] priority, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(pageNo, request, model);
    }

    private WebErrors validateSave(Shipping bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        bean.setWebsite(SiteUtils.getWeb((HttpServletRequest)request));
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private WebErrors validatePriority(Long[] wids, Integer[] priority, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifEmpty((Object[])wids, "wids")) {
            return errors;
        }
        if (errors.ifEmpty((Object[])priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("wids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            this.vldExist(wids[i], errors);
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }

    private boolean vldExist(Long id, WebErrors errors) {
        Shipping entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, Shipping.class, (Serializable)id);
    }
}

