/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.ShopAdmin;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.manager.ShopAdminMng;
import com.jspgou.cms.manager.WebserviceMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.AdminMng;
import com.jspgou.core.manager.RoleMng;
import com.jspgou.core.manager.UserMng;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShopAdminAct {
    private static final Logger log = LoggerFactory.getLogger(ShopAdminAct.class);
    @Autowired
    private ShopAdminMng manager;
    @Autowired
    private UserMng userMng;
    @Autowired
    protected RoleMng roleMng;
    @Autowired
    protected AdminMng adminMng;
    @Autowired
    private WebserviceMng webserviceMng;

    @RequestMapping(value={"/admin/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(SiteUtils.getWebId((HttpServletRequest)request), SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute((Object)pagination);
        return "admin/list";
    }

    @RequestMapping(value={"/admin/v_add.do"})
    public String add(ModelMap model) {
        List roleList = this.roleMng.getList();
        model.addAttribute("roleList", (Object)roleList);
        return "admin/add";
    }

    @RequestMapping(value={"/admin/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        List roleList = this.roleMng.getList();
        model.addAttribute("roleList", (Object)roleList);
        model.addAttribute("admin", (Object)this.manager.findById(id));
        model.addAttribute("roleIds", (Object)this.manager.findById(id).getAdmin().getRoleIds());
        return "admin/edit";
    }

    @RequestMapping(value={"/admin/o_save.do"})
    public String save(ShopAdmin bean, String username, String password, Boolean viewonlyAdmin, String email, Boolean disabled, Integer[] roleIds, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        bean = this.manager.register(username, password, viewonlyAdmin, email, request.getRemoteAddr(), disabled, web.getId(), bean);
        this.webserviceMng.callWebService("true", username, password, email, null, "addUser");
        this.adminMng.addRole(bean.getAdmin(), roleIds);
        log.info("save ShopAdmin id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/admin/o_update.do"})
    public String update(ShopAdmin bean, String password, Boolean viewonlyAdmin, String email, Boolean disabled, Integer[] roleIds, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean, password, disabled, email, viewonlyAdmin);
        ShopMember member = new ShopMember();
        member.setRealName(bean.getFirstname());
        this.webserviceMng.callWebService("true", bean.getUsername(), password, email, member, "updateUser");
        this.adminMng.updateRole(bean.getAdmin(), roleIds);
        log.info("update ShopAdmin id={}.", (Object)bean.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/admin/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        ShopAdmin[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        ShopAdmin[] shopAdminArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            ShopAdmin bean = shopAdminArray[n2];
            HashMap<String, String> paramsValues = new HashMap<String, String>();
            paramsValues.put("username", bean.getUsername());
            paramsValues.put("admin", "true");
            this.webserviceMng.callWebService("deleteUser", paramsValues);
            log.info("delete ShopAdmin id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/admin/v_check_username.do"})
    public String checkUsername(String username, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((String)username) || this.userMng.usernameExist(username)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
        } else {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
        }
        return null;
    }

    @RequestMapping(value={"/admin/v_check_email.do"})
    public String checkEmail(String email, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((String)email) || this.userMng.emailExist(email)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
        } else {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
        }
        return null;
    }

    private WebErrors validateSave(ShopAdmin bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (this.vldExist(id, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, WebErrors errors) {
        ShopAdmin entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, ShopAdmin.class, (Serializable)id);
    }

    private Set<String> handleperms(String[] perms) {
        HashSet<String> permSet = new HashSet<String>();
        String[] stringArray = perms;
        int n = perms.length;
        int n2 = 0;
        while (n2 < n) {
            String perm = stringArray[n2];
            String[] arr = perm.split("@");
            int i = 0;
            int len = arr.length;
            while (i < len) {
                permSet.add(arr[i]);
                ++i;
            }
            ++n2;
        }
        return permSet;
    }
}

