/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.ShopArticle;
import com.jspgou.cms.entity.ShopChannel;
import com.jspgou.cms.manager.ShopArticleMng;
import com.jspgou.cms.manager.ShopChannelMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShopArticleAct {
    private static final Logger log = LoggerFactory.getLogger(ShopArticleAct.class);
    @Autowired
    private ShopChannelMng channelMng;
    @Autowired
    private ShopArticleMng manager;

    @RequestMapping(value={"/article/v_left.do"})
    public String left() {
        return "article/left";
    }

    @RequestMapping(value={"/article/v_tree.do"})
    public String tree(String root, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        List<ShopChannel> list;
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        log.debug("tree path={}", (Object)root);
        boolean isRoot = StringUtils.isBlank((String)root) || "source".equals(root);
        model.addAttribute("isRoot", (Object)isRoot);
        WebErrors errors = this.validateTree(root, request);
        if (errors.hasErrors()) {
            log.error((String)errors.getErrors().get(0));
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"[]");
            return null;
        }
        if (isRoot) {
            list = this.channelMng.getTopList(web.getId());
        } else {
            Long rootId = Long.valueOf(root);
            list = this.channelMng.getChildList(web.getId(), rootId);
        }
        model.addAttribute("list", list);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/json;charset=UTF-8");
        return "article/tree";
    }

    @RequestMapping(value={"/article/v_list.do"})
    public String list(Long cid, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        Pagination pagination = this.manager.getPage(cid, web.getId(), SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        if (cid != null) {
            ShopChannel channel = this.channelMng.findById(cid);
            model.addAttribute("channel", (Object)channel);
        }
        model.addAttribute("cid", (Object)cid);
        return "article/list";
    }

    @RequestMapping(value={"/article/v_add.do"})
    public String add(Long cid, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        List<ShopChannel> channelList = this.channelMng.getArticleList(web.getId());
        model.addAttribute("channelList", channelList);
        if (cid != null) {
            model.addAttribute("cid", (Object)cid);
        }
        return "article/add";
    }

    @RequestMapping(value={"/article/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        List<ShopChannel> articleChannelList = this.channelMng.getArticleList(web.getId());
        model.addAttribute("articleChannelList", articleChannelList);
        model.addAttribute("shopArticle", (Object)this.manager.findById(id));
        return "article/edit";
    }

    @RequestMapping(value={"/article/o_save.do"})
    public String save(ShopArticle bean, Long channelId, String content, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, channelId, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean, channelId, content);
        log.info("save ShopArticle id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/article/o_update.do"})
    public String update(ShopArticle bean, Long channelId, String content, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), channelId, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean, channelId, content);
        log.info("update ShopArticle id={}.", (Object)bean.getId());
        return this.list(null, pageNo, request, model);
    }

    @RequestMapping(value={"/article/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        ShopArticle[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        ShopArticle[] shopArticleArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            ShopArticle bean = shopArticleArray[n2];
            log.info("delete ShopArticle id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(null, pageNo, request, model);
    }

    private WebErrors validateSave(ShopArticle bean, Long channelId, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        bean.setWebsite(web);
        if (errors.ifNull((Object)channelId, "channelId")) {
            return errors;
        }
        ShopChannel channel = this.channelMng.findById(channelId);
        if (!channel.getWebsite().getId().equals(web.getId())) {
            errors.notInWeb(ShopChannel.class, (Serializable)channelId);
            return errors;
        }
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, Long channelId, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        ShopChannel channel = this.channelMng.findById(channelId);
        if (!channel.getWebsite().getId().equals(web.getId())) {
            errors.notInWeb(ShopChannel.class, (Serializable)channelId);
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        ShopArticle entity = this.manager.findById(id);
        if (errors.ifNotExist((Object)entity, ShopArticle.class, (Serializable)id)) {
            return true;
        }
        if (!entity.getWebsite().getId().equals(webId)) {
            errors.notInWeb(ShopArticle.class, (Serializable)id);
            return true;
        }
        return false;
    }

    private WebErrors validateTree(String path, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }
}

