/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.ShopChannel;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ShopArticleMng;
import com.jspgou.cms.manager.ShopChannelMng;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.ServletContextAware;

@Controller
public class ShopChannelAct
implements ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(ShopChannelAct.class);
    @Autowired
    private ShopChannelMng manager;
    private ServletContext servletContext;
    @Autowired
    private ShopArticleMng shopArticleMng;
    @Autowired
    private ShopChannelMng shopChannelMng;
    @Autowired
    private ProductMng productMng;

    @RequestMapping(value={"/channel/v_left.do"})
    public String left() {
        return "channel/left";
    }

    @RequestMapping(value={"/channel/v_tree.do"})
    public String tree(String root, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        List<ShopChannel> list;
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        log.debug("tree path={}", (Object)root);
        boolean isRoot = StringUtils.isBlank((String)root) || "source".equals(root);
        model.addAttribute("isRoot", (Object)isRoot);
        WebErrors errors = this.validateTree(root, request);
        if (errors.hasErrors()) {
            log.error((String)errors.getErrors().get(0));
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"[]");
            return null;
        }
        if (isRoot) {
            list = this.manager.getTopList(web.getId());
        } else {
            Long rootId = Long.valueOf(root);
            list = this.manager.getChildList(web.getId(), rootId);
        }
        model.addAttribute("list", list);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/json;charset=UTF-8");
        return "channel/tree";
    }

    @RequestMapping(value={"/channel/v_list.do"})
    public String list(Long root, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        List<ShopChannel> list = root == null ? this.manager.getTopList(web.getId()) : this.manager.getChildList(web.getId(), root);
        model.addAttribute("root", (Object)root);
        model.addAttribute("list", list);
        return "channel/list";
    }

    @RequestMapping(value={"/channel/v_add.do"})
    public String add(Long root, Integer type, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopChannel parent = null;
        if (root != null) {
            parent = this.manager.findById(root);
            model.addAttribute("parent", (Object)parent);
            model.addAttribute("root", (Object)root);
        }
        String tplChannelDirRel = ShopChannel.getChannelTplDirRel(web);
        String realChannelDir = this.servletContext.getRealPath(tplChannelDirRel);
        String relChannelPath = tplChannelDirRel.substring(web.getTemplateRel().length());
        String[] channelTpls = ShopChannel.getChannelTpls(type, realChannelDir, relChannelPath);
        String tplContentDirRel = ShopChannel.getContentTplDirRel(web);
        String realContentDir = this.servletContext.getRealPath(tplContentDirRel);
        String relContentPath = tplContentDirRel.substring(web.getTemplateRel().length());
        String[] contentTpls = ShopChannel.getContentTpls(type, realContentDir, relContentPath);
        model.addAttribute("channelTpls", (Object)channelTpls);
        model.addAttribute("contentTpls", (Object)contentTpls);
        model.addAttribute("type", (Object)type);
        return "channel/add";
    }

    @RequestMapping(value={"/channel/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        ShopChannel shopChannel = this.manager.findById(id);
        Integer type = shopChannel.getType();
        String tplChannelDirRel = ShopChannel.getChannelTplDirRel(web);
        String realChannelDir = this.servletContext.getRealPath(tplChannelDirRel);
        String relChannelPath = tplChannelDirRel.substring(web.getTemplateRel().length());
        String[] channelTpls = ShopChannel.getChannelTpls(type, realChannelDir, relChannelPath);
        String tplContentDirRel = ShopChannel.getContentTplDirRel(web);
        String realContentDir = this.servletContext.getRealPath(tplContentDirRel);
        String relContentPath = tplContentDirRel.substring(web.getTemplateRel().length());
        String[] contentTpls = ShopChannel.getContentTpls(type, realContentDir, relContentPath);
        model.addAttribute("channelTpls", (Object)channelTpls);
        model.addAttribute("contentTpls", (Object)contentTpls);
        List<ShopChannel> parentList = this.manager.getListForParent(web.getId(), (Long)shopChannel.getId());
        model.addAttribute("parentList", parentList);
        model.addAttribute("shopChannel", (Object)shopChannel);
        return "channel/edit";
    }

    @RequestMapping(value={"/channel/o_save.do"})
    public String save(Long root, ShopChannel bean, String content, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, root, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean, root, content);
        log.info("save ShopChannel id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/channel/o_update.do"})
    public String update(ShopChannel bean, Long parentId, String content, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate((Long)bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean, parentId, content);
        log.info("update ShopChannel id={}.", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/channel/o_delete.do"})
    public String delete(Long[] ids, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            ShopChannel[] beans;
            ShopChannel[] shopChannelArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                ShopChannel bean = shopChannelArray[n2];
                log.info("delete ShopChannel id={}", (Object)bean.getId());
                ++n2;
            }
        }
        catch (Exception e) {
            errors.addErrorString(this.productMng.getTipFile("Please.delete.the.corresponding.article.under.the.change.column"));
            return errors.showErrorPage(model);
        }
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/channel/o_priority.do"})
    public String priority(Long[] wids, Integer[] priority, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(null, request, model);
    }

    private WebErrors validatePriority(Long[] wids, Integer[] priority, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifEmpty((Object[])wids, "wids")) {
            return errors;
        }
        if (errors.ifEmpty((Object[])priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("wids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            this.vldExist(wids[i], errors);
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }

    private void vldExist(Long id, WebErrors errors) {
        if (errors.hasErrors()) {
            return;
        }
        ShopChannel entity = this.manager.findById(id);
        errors.ifNotExist((Object)entity, ShopChannel.class, (Serializable)id);
    }

    private WebErrors validateSave(ShopChannel bean, Long parentId, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        bean.setWebsite(web);
        if (parentId != null && this.vldExist(parentId, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        ShopChannel entity = this.manager.findById(id);
        if (errors.ifNotExist((Object)entity, ShopChannel.class, (Serializable)id)) {
            return true;
        }
        if (!entity.getWebsite().getId().equals(webId)) {
            errors.notInWeb(ShopChannel.class, (Serializable)id);
            return true;
        }
        return false;
    }

    private WebErrors validateTree(String path, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

