/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.ShopDictionary;
import com.jspgou.cms.entity.ShopDictionaryType;
import com.jspgou.cms.manager.ShopDictionaryMng;
import com.jspgou.cms.manager.ShopDictionaryTypeMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShopDictionaryAct {
    private static final Logger log = LoggerFactory.getLogger(ShopDictionaryAct.class);
    @Autowired
    private ShopDictionaryMng manager;
    @Autowired
    private ShopDictionaryTypeMng shopDictionaryTypeMng;

    @RequestMapping(value={"/shopDictionary/v_list.do"})
    public String list(Long typeId, Integer pageNo, HttpServletRequest request, ModelMap model) {
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        List<ShopDictionaryType> typelist = this.shopDictionaryTypeMng.findAll();
        Pagination pagination = this.manager.getPage(name, typeId, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("name", (Object)name);
        model.addAttribute("typeId", (Object)typeId);
        model.addAttribute("typelist", typelist);
        model.addAttribute("pagination", (Object)pagination);
        return "shopDictionary/list";
    }

    @RequestMapping(value={"/shopDictionary/v_add.do"})
    public String add(ModelMap model) {
        List<ShopDictionaryType> sdtList = this.shopDictionaryTypeMng.findAll();
        model.addAttribute("sdtList", sdtList);
        return "shopDictionary/add";
    }

    @RequestMapping(value={"/shopDictionary/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        List<ShopDictionaryType> sdtList = this.shopDictionaryTypeMng.findAll();
        model.addAttribute("sdtList", sdtList);
        model.addAttribute("shopDictionary", (Object)this.manager.findById(id));
        return "shopDictionary/edit";
    }

    @RequestMapping(value={"/shopDictionary/o_save.do"})
    public String save(ShopDictionary bean, Long shopDictionaryTypeId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean.setShopDictionaryType(this.shopDictionaryTypeMng.findById(shopDictionaryTypeId));
        bean = this.manager.save(bean);
        log.info("save ShopDictionary id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/shopDictionary/o_update.do"})
    public String update(ShopDictionary bean, Long shopDictionaryTypeId, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean.setShopDictionaryType(this.shopDictionaryTypeMng.findById(shopDictionaryTypeId));
        bean = this.manager.update(bean);
        log.info("update ShopDictionary id={}.", (Object)bean.getId());
        return this.list(null, pageNo, request, model);
    }

    @RequestMapping(value={"/shopDictionary/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        ShopDictionary[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        ShopDictionary[] shopDictionaryArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            ShopDictionary bean = shopDictionaryArray[n2];
            log.info("delete ShopDictionary id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(null, pageNo, request, model);
    }

    @RequestMapping(value={"/shopDictionary/o_priority.do"})
    public String priority(Integer pageNo, Long[] wids, Integer[] priority, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(null, pageNo, request, model);
    }

    private WebErrors validateSave(ShopDictionary bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        ShopDictionary entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, ShopDictionary.class, (Serializable)id);
    }

    private WebErrors validatePriority(Long[] wids, Integer[] priority, HttpServletRequest request) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifEmpty((Object[])wids, "ids")) {
            return errors;
        }
        if (errors.ifEmpty((Object[])priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("ids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            if (this.vldExist(wids[i], web.getId(), errors)) {
                return errors;
            }
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }
}

