/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.ShopDictionaryType;
import com.jspgou.cms.manager.ShopDictionaryTypeMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShopDictionaryTypeAct {
    private static final Logger log = LoggerFactory.getLogger(ShopDictionaryTypeAct.class);
    @Autowired
    private ShopDictionaryTypeMng manager;

    @RequestMapping(value={"/shopDictionaryType/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return "shopDictionaryType/list";
    }

    @RequestMapping(value={"/shopDictionaryType/v_add.do"})
    public String add(ModelMap model) {
        return "shopDictionaryType/add";
    }

    @RequestMapping(value={"/shopDictionaryType/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("shopDictionaryType", (Object)this.manager.findById(id));
        return "shopDictionaryType/edit";
    }

    @RequestMapping(value={"/shopDictionaryType/o_save.do"})
    public String save(ShopDictionaryType bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save ShopDictionaryType id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/shopDictionaryType/o_update.do"})
    public String update(ShopDictionaryType bean, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update ShopDictionaryType id={}.", (Object)bean.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/shopDictionaryType/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        ShopDictionaryType[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        ShopDictionaryType[] shopDictionaryTypeArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            ShopDictionaryType bean = shopDictionaryTypeArray[n2];
            log.info("delete ShopDictionaryType id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    private WebErrors validateSave(ShopDictionaryType bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        ShopDictionaryType entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, ShopDictionaryType.class, (Serializable)id);
    }
}

