/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.ShopDictionary;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.ShopMemberGroup;
import com.jspgou.cms.manager.ShopDictionaryMng;
import com.jspgou.cms.manager.ShopMemberGroupMng;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.cms.manager.WebserviceMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.UserMng;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShopMemberAct {
    private static final Logger log = LoggerFactory.getLogger(ShopMemberAct.class);
    @Autowired
    private ShopMemberGroupMng shopMemberGroupMng;
    @Autowired
    private UserMng userMng;
    @Autowired
    private ShopMemberMng manager;
    @Autowired
    private ShopDictionaryMng shopDictionaryMng;
    @Autowired
    private WebserviceMng webserviceMng;

    @RequestMapping(value={"/member/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(SiteUtils.getWebId((HttpServletRequest)request), SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return "member/list";
    }

    @RequestMapping(value={"/member/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        List<ShopMemberGroup> groupList = this.shopMemberGroupMng.getList(SiteUtils.getWebId((HttpServletRequest)request));
        List<ShopDictionary> userDegreeList = this.shopDictionaryMng.getListByType(1L);
        List<ShopDictionary> familyMembersList = this.shopDictionaryMng.getListByType(2L);
        List<ShopDictionary> incomeDescList = this.shopDictionaryMng.getListByType(3L);
        List<ShopDictionary> workSeniorityList = this.shopDictionaryMng.getListByType(4L);
        List<ShopDictionary> degreeList = this.shopDictionaryMng.getListByType(5L);
        model.addAttribute("groupList", groupList);
        model.addAttribute("userDegreeList", userDegreeList);
        model.addAttribute("familyMembersList", familyMembersList);
        model.addAttribute("incomeDescList", incomeDescList);
        model.addAttribute("workSeniorityList", workSeniorityList);
        model.addAttribute("degreeList", degreeList);
        return "member/add";
    }

    @RequestMapping(value={"/member/o_save.do"})
    public String save(ShopMember bean, Long groupId, Long userDegreeId, Long degreeId, Long incomeDescId, Long workSeniorityId, Long familyMembersId, String username, String password, String email, Boolean disabled, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, username, email, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.register(username, password, email, true, null, request.getRemoteAddr(), disabled, SiteUtils.getWebId((HttpServletRequest)request), groupId, userDegreeId, degreeId, incomeDescId, workSeniorityId, familyMembersId, bean);
        this.webserviceMng.callWebService("false", username, password, email, null, "addUser");
        log.info("save ShopMember, id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/member/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        List<ShopMemberGroup> groupList = this.shopMemberGroupMng.getList(SiteUtils.getWebId((HttpServletRequest)request));
        List<ShopDictionary> userDegreeList = this.shopDictionaryMng.getListByType(1L);
        List<ShopDictionary> familyMembersList = this.shopDictionaryMng.getListByType(2L);
        List<ShopDictionary> incomeDescList = this.shopDictionaryMng.getListByType(3L);
        List<ShopDictionary> workSeniorityList = this.shopDictionaryMng.getListByType(4L);
        List<ShopDictionary> degreeList = this.shopDictionaryMng.getListByType(5L);
        ShopMember member = this.manager.findById(id);
        model.addAttribute("groupList", groupList);
        model.addAttribute("member", (Object)member);
        model.addAttribute("groupList", groupList);
        model.addAttribute("userDegreeList", userDegreeList);
        model.addAttribute("familyMembersList", familyMembersList);
        model.addAttribute("incomeDescList", incomeDescList);
        model.addAttribute("workSeniorityList", workSeniorityList);
        model.addAttribute("degreeList", degreeList);
        return "member/edit";
    }

    @RequestMapping(value={"/member/o_update.do"})
    public String update(ShopMember bean, Long groupId, Long userDegreeId, Long degreeId, Long incomeDescId, Long workSeniorityId, Long familyMembersId, String password, String email, Boolean disabled, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), email, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean, groupId, userDegreeId, degreeId, incomeDescId, workSeniorityId, familyMembersId, password, email, disabled);
        this.webserviceMng.callWebService("false", bean.getUsername(), password, email, null, "updateUser");
        log.info("update ShopMember, id={}.", (Object)bean.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/member/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        ShopMember[] beans;
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        ShopMember[] shopMemberArray = beans = this.manager.deleteByIds(ids);
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            ShopMember bean = shopMemberArray[n2];
            HashMap<String, String> paramsValues = new HashMap<String, String>();
            paramsValues.put("username", bean.getUsername());
            paramsValues.put("admin", "true");
            this.webserviceMng.callWebService("deleteUser", paramsValues);
            log.info("delete ShopMember, id={}", (Object)bean.getId());
            ++n2;
        }
        return this.list(pageNo, request, model);
    }

    private WebErrors validateSave(ShopMember bean, String username, String email, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        bean.setWebsite(web);
        if (this.vldUsername(username, errors)) {
            return errors;
        }
        if (this.vldEmail(email, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, String email, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldEmailUpdate(id, email, errors)) {
            return errors;
        }
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.hasErrors()) {
            return true;
        }
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        ShopMember entity = this.manager.findById(id);
        if (errors.ifNotExist((Object)entity, ShopMember.class, (Serializable)id)) {
            return true;
        }
        if (!entity.getWebsite().getId().equals(webId)) {
            errors.notInWeb(ShopMember.class, (Serializable)id);
            return true;
        }
        return false;
    }

    private boolean vldEmailUpdate(Long id, String email, WebErrors errors) {
        ShopMember member;
        return !StringUtils.isBlank((String)email) && (member = this.manager.findById(id)).getEmail() != null && !member.getEmail().equals(email) && this.vldEmail(email, errors);
    }

    private boolean vldEmail(String email, WebErrors errors) {
        if (errors.ifNotEmail(email, "email", 100)) {
            return true;
        }
        if (this.userMng.emailExist(email)) {
            errors.addErrorCode("error.emailExist");
            return true;
        }
        return false;
    }

    private boolean vldUsername(String username, WebErrors errors) {
        if (errors.ifNotUsername(username, "username", 3, 100)) {
            return true;
        }
        if (this.userMng.usernameExist(username)) {
            errors.addErrorCode("error.usernameExist");
            return true;
        }
        return false;
    }
}

