/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.ShopMemberGroup;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ShopMemberGroupMng;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShopMemberGroupAct {
    private static final Logger log = LoggerFactory.getLogger(ShopMemberGroupAct.class);
    @Autowired
    private ProductMng productMng;
    @Autowired
    private ShopMemberGroupMng manager;

    @RequestMapping(value={"/group/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        List<ShopMemberGroup> list = this.manager.getList(SiteUtils.getWebId((HttpServletRequest)request));
        model.addAttribute("list", list);
        return "group/list";
    }

    @RequestMapping(value={"/group/v_add.do"})
    public String add(ModelMap model) {
        return "group/add";
    }

    @RequestMapping(value={"/group/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("group", (Object)this.manager.findById(id));
        return "group/edit";
    }

    @RequestMapping(value={"/group/o_save.do"})
    public String save(ShopMemberGroup bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        log.info("save ShopMemberGroup. id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/group/o_update.do"})
    public String update(ShopMemberGroup bean, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update ShopMemberGroup. id={}.", (Object)bean.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/group/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            ShopMemberGroup[] beans;
            ShopMemberGroup[] shopMemberGroupArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                ShopMemberGroup bean = shopMemberGroupArray[n2];
                log.info("delete ShopMemberGroup. id={}", (Object)bean.getId());
                ++n2;
            }
        }
        catch (Exception e) {
            errors.addErrorString(this.productMng.getTipFile("Please.delete.the.member.then.delete.the.operation"));
            return errors.showErrorPage(model);
        }
        return this.list(pageNo, request, model);
    }

    private WebErrors validateSave(ShopMemberGroup bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        bean.setWebsite(SiteUtils.getWeb((HttpServletRequest)request));
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private void vldExist(Long id, WebErrors errors) {
        if (errors.hasErrors()) {
            return;
        }
        ShopMemberGroup entity = this.manager.findById(id);
        errors.ifNotExist((Object)entity, ShopMemberGroup.class, (Serializable)id);
    }
}

