/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Standard;
import com.jspgou.cms.entity.StandardType;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.StandardMng;
import com.jspgou.cms.manager.StandardTypeMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class StandardTypeAct {
    private static final Logger log = LoggerFactory.getLogger(StandardTypeAct.class);
    @Autowired
    private StandardTypeMng manager;
    @Autowired
    private StandardMng standardMng;
    @Autowired
    private ProductMng productMng;

    @RequestMapping(value={"/standardType/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return "standardType/list";
    }

    @RequestMapping(value={"/standardType/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        return "standardType/add";
    }

    @RequestMapping(value={"/standardType/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        StandardType bean = this.manager.findById(id);
        List<Standard> standards = this.standardMng.findByTypeId(id);
        model.addAttribute("standardType", (Object)bean);
        model.addAttribute("standards", standards);
        return "standardType/edit";
    }

    @RequestMapping(value={"/standardType/o_save.do"})
    public String save(StandardType bean, String[] itemName, String[] itemColor, Integer[] itemPriority, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.save(bean);
        this.addStandard(bean, itemName, itemColor, itemPriority);
        log.info("save StandardType id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/standardType/o_update.do"})
    public String update(StandardType bean, Long[] itemId, String[] itemName, String[] itemColor, Integer[] itemPriority, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        this.updateStandard(bean, itemId, itemName, itemColor, itemPriority);
        log.info("update StandardType id={}.", (Object)bean.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/standardType/o_priority.do"})
    public String priority(Integer pageNo, Long[] wids, Integer[] priority, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/standardType/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            StandardType[] beans;
            StandardType[] standardTypeArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                StandardType bean = standardTypeArray[n2];
                log.info("delete StandardType id={}", (Object)bean.getId());
                ++n2;
            }
        }
        catch (Exception e) {
            errors.addErrorString(this.productMng.getTipFile("Please.remove.dele"));
            return errors.showErrorPage(model);
        }
        return this.list(pageNo, request, model);
    }

    private void addStandard(StandardType bean, String[] itemName, String[] itemColor, Integer[] itemPriority) {
        if (itemName != null) {
            int i = 0;
            int len = itemName.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)itemName[i])) {
                    Standard item = new Standard();
                    item.setName(itemName[i]);
                    item.setColor(itemColor[i]);
                    item.setPriority(itemPriority[i]);
                    item.setType(bean);
                    this.standardMng.save(item);
                }
                ++i;
            }
        }
    }

    @RequestMapping(value={"/standardType/v_check_field.do"})
    public String checkUsername(String field, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((String)field) || this.manager.getByField(field) != null) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
        } else {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
        }
        return null;
    }

    private void updateStandard(StandardType bean, Long[] itemId, String[] itemName, String[] itemColor, Integer[] itemPriority) {
        Set<Standard> set = bean.getStandardSet();
        if (itemId != null) {
            for (Standard s : set) {
                if (Arrays.asList(itemId).contains(s.getId())) continue;
                this.standardMng.deleteById(s.getId());
            }
        } else {
            for (Standard s : set) {
                this.standardMng.deleteById(s.getId());
            }
        }
        if (itemName != null) {
            int i = 0;
            int len = itemName.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)itemName[i])) {
                    Standard item;
                    if (itemId != null && i < itemId.length) {
                        item = this.standardMng.findById(itemId[i]);
                        item.setName(itemName[i]);
                        item.setColor(itemColor[i]);
                        item.setPriority(itemPriority[i]);
                        item.setType(bean);
                        this.standardMng.update(item);
                    } else {
                        item = new Standard();
                        item.setName(itemName[i]);
                        item.setColor(itemColor[i]);
                        item.setPriority(itemPriority[i]);
                        item.setType(bean);
                        this.standardMng.save(item);
                    }
                }
                ++i;
            }
        }
    }

    private WebErrors validateSave(StandardType bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        StandardType entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, StandardType.class, (Serializable)id);
    }

    private WebErrors validatePriority(Long[] wids, Integer[] priority, HttpServletRequest request) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifEmpty((Object[])wids, "ids")) {
            return errors;
        }
        if (errors.ifEmpty((Object[])priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("ids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            if (this.vldExist(wids[i], web.getId(), errors)) {
                return errors;
            }
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }
}

