/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.manager.ResourceMng;
import com.jspgou.common.file.FileWrap;
import com.jspgou.common.util.Zipper;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.TemplateMng;
import com.jspgou.core.tpl.TplManager;
import com.jspgou.core.web.SiteUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class TemplateAct
implements ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(TemplateAct.class);
    private static final String REL_PATH = "relPath";
    @Autowired
    private TemplateMng manager;
    private ServletContext servletContext;
    private ResourceMng resourceMng;
    private TplManager tplManager;

    @RequestMapping(value={"/template/v_left.do"})
    public String left(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String tplReal = this.servletContext.getRealPath(web.getTemplateRel());
        String tplName = MessageResolver.getMessage((HttpServletRequest)request, (String)"template.tplName", (Object[])new Object[0]);
        FileWrap wrap = this.manager.getTplFileWrap(tplReal, tplName);
        model.addAttribute("treeRoot", (Object)wrap);
        return "template/left";
    }

    @RequestMapping(value={"/template/o_swfupload.do"}, method={RequestMethod.POST})
    public void swfUpload(String root, @RequestParam(value="Filedata", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IllegalStateException, IOException {
        this.tplManager.save(root, file);
        model.addAttribute("root", (Object)root);
        log.info("file upload seccess: {}, size:{}.", (Object)file.getOriginalFilename(), (Object)file.getSize());
        ResponseUtils.renderText((HttpServletResponse)response, (String)"");
    }

    @RequestMapping(value={"/template/v_tree.do"}, method={RequestMethod.GET})
    public String tree(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        log.debug("tree path={}", (Object)root);
        if (StringUtils.isBlank((String)root) || "source".equals(root)) {
            root = web.getTemplateRel();
            model.addAttribute("isRoot", (Object)true);
        } else {
            model.addAttribute("isRoot", (Object)false);
        }
        List tplList = this.tplManager.getChild(root);
        model.addAttribute("tplList", (Object)tplList);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/json;charset=UTF-8");
        return "template/tree";
    }

    @RequestMapping(value={"/template/v_list.do"}, method={RequestMethod.GET})
    public String list(HttpServletRequest request, ModelMap model) {
        String rel;
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String root = (String)model.get((Object)"root");
        if (root == null) {
            root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        }
        log.debug("list Template root: {}", (Object)root);
        if (StringUtils.isBlank((String)root)) {
            root = new String(web.getTemplateRelBuff());
        }
        if ((rel = root.substring(new String(web.getTemplateRelBuff()).length())).length() == 0) {
            rel = "/";
        }
        model.addAttribute("root", (Object)root);
        model.addAttribute("rel", (Object)rel);
        model.addAttribute("list", (Object)this.tplManager.getChild(root));
        return "template/list";
    }

    @RequestMapping(value={"/template/o_create_dir.do"})
    public String createDir(String relPath, String dirName, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String real = this.servletContext.getRealPath(web.getTemplateRel(relPath));
        File file = new File(real, dirName);
        if (!file.exists()) {
            file.mkdirs();
        }
        model.addAttribute(REL_PATH, (Object)relPath);
        return this.list(request, model);
    }

    @RequestMapping(value={"/template/v_rename.do"}, method={RequestMethod.GET})
    public String renameInput(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        String origName = name.substring(web.getTemplateRel().length());
        model.addAttribute("origName", (Object)origName);
        model.addAttribute("root", (Object)root);
        return "template/rename";
    }

    @RequestMapping(value={"/template/o_rename.do"})
    public String renameUpdate(String relPath, String origName, String newName, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String real = this.servletContext.getRealPath(web.getTemplateRel(relPath));
        File origFile = new File(real, origName);
        File newFile = new File(real, newName);
        origFile.renameTo(newFile);
        log.info("rename template dir {} to {}", (Object)origFile.getAbsolutePath(), (Object)newFile.getAbsolutePath());
        model.addAttribute(REL_PATH, (Object)relPath);
        return this.list(request, model);
    }

    @RequestMapping(value={"/template/v_add.do"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, ModelMap model) {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        model.addAttribute("root", (Object)root);
        return "template/add";
    }

    @RequestMapping(value={"/template/v_edit.do"})
    public String edit(HttpServletRequest request, ModelMap model) {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        model.addAttribute("template", (Object)this.tplManager.get(name));
        model.addAttribute("root", (Object)root);
        return "template/edit";
    }

    @RequestMapping(value={"/template/o_save.do"})
    public String save(String root, String filename, String source, HttpServletRequest request, ModelMap model) {
        String name = String.valueOf(root) + "/" + filename + ".html";
        this.tplManager.save(name, source, false);
        model.addAttribute("root", (Object)root);
        log.info("save Template name={}", (Object)filename);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/template/o_update.do"})
    public void update(String root, String name, String source, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        this.tplManager.update(name, source);
        log.info("update Template name={}.", (Object)name);
        model.addAttribute("root", (Object)root);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)"{success:true}");
    }

    @RequestMapping(value={"/template/o_delete.do"})
    public String delete(String root, String[] names, HttpServletRequest request, ModelMap model) {
        int count = this.tplManager.delete(names);
        log.info("delete Template count: {}", (Object)count);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            log.info("delete Template name={}", (Object)name);
            ++n2;
        }
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/template/o_delete_single.do"})
    public String deleteSingle(HttpServletRequest request, ModelMap model) {
        String root = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"root");
        String name = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"name");
        int count = this.tplManager.delete(new String[]{name});
        log.info("delete Template {}, count {}", (Object)name, (Object)count);
        model.addAttribute("root", (Object)root);
        return this.list(request, model);
    }

    @RequestMapping(value={"/template/v_solution.do"})
    public String solutionInput(HttpServletRequest request, ModelMap model) {
        return "template/solution";
    }

    @RequestMapping(value={"/template/o_export.do"})
    public void templateExport(HttpServletRequest request, HttpServletResponse response) {
        List<Zipper.FileEntry> fileEntrys = this.resourceMng.export();
        response.setContentType("application/x-download;charset=UTF-8");
        response.addHeader("Content-disposition", "filename=template.zip");
        try {
            Zipper.zip((OutputStream)response.getOutputStream(), fileEntrys, (String)"GBK");
        }
        catch (IOException e) {
            log.error("export template error!", (Throwable)e);
        }
    }

    @RequestMapping(value={"/template/o_solution.do"})
    public String solutionUpdate(HttpServletRequest request, ModelMap model) {
        return this.solutionInput(request, model);
    }

    @RequestMapping(value={"/template/o_import.do"})
    public String importSubmit(@RequestParam(value="tplZip", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IOException {
        Website site = SiteUtils.getWeb((HttpServletRequest)request);
        File tempFile = File.createTempFile("tplZip", "temp");
        file.transferTo(tempFile);
        this.resourceMng.imoport(tempFile, site);
        tempFile.delete();
        return this.solutionInput(request, model);
    }

    public void setTplManager(TplManager tplManager) {
        this.tplManager = tplManager;
    }

    @Autowired
    public void setResourceMng(ResourceMng resourceMng) {
        this.resourceMng = resourceMng;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

