/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Webservice;
import com.jspgou.cms.manager.WebserviceMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class WebserviceAct {
    private static final Logger log = LoggerFactory.getLogger(WebserviceAct.class);
    @Autowired
    private WebserviceMng manager;

    @RequestMapping(value={"/webservice/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        return "webservice/list";
    }

    @RequestMapping(value={"/webservice/v_add.do"})
    public String add(ModelMap model) {
        return "webservice/add";
    }

    @RequestMapping(value={"/webservice/v_edit.do"})
    public String edit(Integer id, HttpServletRequest request, ModelMap model) {
        model.addAttribute("Webservice", (Object)this.manager.findById(id));
        return "webservice/edit";
    }

    @RequestMapping(value={"/webservice/o_save.do"})
    public String save(Webservice bean, String[] paramName, String[] defaultValue, HttpServletRequest request, ModelMap model) {
        bean = this.manager.save(bean, paramName, defaultValue);
        log.info("save Webservice id={}", (Object)bean);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/webservice/o_update.do"})
    public String update(Webservice bean, String[] paramName, String[] defaultValue, Integer pageNo, HttpServletRequest request, ModelMap model) {
        bean = this.manager.update(bean, paramName, defaultValue);
        log.info("update Webservice id={}.", (Object)bean.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/webservice/o_delete.do"})
    public String delete(Integer[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        this.manager.deleteByIds(ids);
        return this.list(pageNo, request, model);
    }
}

