/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.directive;

import com.jspgou.cms.action.directive.abs.WebDirective;
import com.jspgou.cms.entity.ShopChannel;
import com.jspgou.cms.manager.ShopChannelMng;
import com.jspgou.common.web.freemarker.DirectiveUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.WebsiteMng;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ChannelListDirective
extends WebDirective {
    public static final String TPL_NAME = "TopChannel";
    private ShopChannelMng shopChannelMng;
    private WebsiteMng websiteMng;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        ShopChannel channel;
        Long webId = this.getWebId(params);
        Website web = webId == null ? this.getWeb(env, params, this.websiteMng) : this.websiteMng.findById(webId);
        if (web == null) {
            throw new TemplateModelException("webId=" + webId + " not exist!");
        }
        Long parentId = DirectiveUtils.getLong((String)"parentId", (Map)params);
        List<ShopChannel> list = parentId != null ? ((channel = this.shopChannelMng.findById(parentId)) != null ? new ArrayList<ShopChannel>(channel.getChild()) : new ArrayList<ShopChannel>()) : this.shopChannelMng.getTopListForTag(web.getId(), this.getCount(params));
        HashMap<String, TemplateModel> paramsWrap = new HashMap<String, TemplateModel>(params);
        paramsWrap.put("tag_list", ObjectWrapper.DEFAULT_WRAPPER.wrap(list));
        Map origMap = DirectiveUtils.addParamsToVariable((Environment)env, paramsWrap);
        if (this.isInvokeTpl(params)) {
            this.includeTpl("shop", TPL_NAME, web, params, env);
        } else {
            this.renderBody(env, loopVars, body);
        }
        DirectiveUtils.removeParamsFromVariable((Environment)env, paramsWrap, (Map)origMap);
    }

    private void renderBody(Environment env, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        body.render(env.getOut());
    }

    @Autowired
    public void setShopChannelMng(ShopChannelMng shopChannelMng) {
        this.shopChannelMng = shopChannelMng;
    }

    public void setWebsiteMng(WebsiteMng websiteMng) {
        this.websiteMng = websiteMng;
    }
}

