/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.directive;

import com.jspgou.cms.action.directive.abs.WebDirective;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.manager.ShopScoreMng;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.web.freemarker.DirectiveUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.WebsiteMng;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ScorePageDirective
extends WebDirective {
    public static final String TPL_NAME = "ShopScorePage";
    private ShopScoreMng shopScoreMng;
    private WebsiteMng websiteMng;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        ShopMember member = MemberThread.get();
        Website web = this.getWeb(env, params, this.websiteMng);
        Integer count = this.getCount(params);
        Boolean status = this.getBool("status", params);
        Boolean useStatus = this.getBool("useStatus", params);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String startTime = this.getString("startTime", params);
        String endTime = this.getString("endTime", params);
        Date start = null;
        Date end = null;
        try {
            start = !StringUtils.isBlank((String)startTime) ? df.parse(startTime) : null;
            end = !StringUtils.isBlank((String)endTime) ? df.parse(endTime) : null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Pagination pagination = this.shopScoreMng.getPage(member.getId(), status, useStatus, start, end, this.getPageNo(env), count);
        HashMap<String, TemplateModel> paramWrap = new HashMap<String, TemplateModel>(params);
        paramWrap.put("tag_pagination", ObjectWrapper.DEFAULT_WRAPPER.wrap((Object)pagination));
        paramWrap.put("tag_list", ObjectWrapper.DEFAULT_WRAPPER.wrap((Object)pagination.getList()));
        Map origMap = DirectiveUtils.addParamsToVariable((Environment)env, paramWrap);
        if (this.isInvokeTpl(params)) {
            this.includeTpl("shop", TPL_NAME, web, params, env);
        } else {
            this.renderBody(env, loopVars, body);
        }
        DirectiveUtils.removeParamsFromVariable((Environment)env, paramWrap, (Map)origMap);
    }

    private void renderBody(Environment env, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        body.render(env.getOut());
    }

    @Autowired
    public void setShopScoreMng(ShopScoreMng shopScoreMng) {
        this.shopScoreMng = shopScoreMng;
    }

    @Autowired
    public void setWebsiteMng(WebsiteMng websiteMng) {
        this.websiteMng = websiteMng;
    }
}

