/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.front;

import com.jspgou.cms.Alipay;
import com.jspgou.cms.entity.Order;
import com.jspgou.cms.entity.PaymentPlugins;
import com.jspgou.cms.manager.OrderMng;
import com.jspgou.cms.manager.PaymentPluginsMng;
import com.jspgou.cms.web.FrontUtils;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.front.FrontHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class AlipayAct
extends Alipay {
    @Autowired
    private OrderMng manager;
    @Autowired
    private PaymentPluginsMng paymentPluginsMng;

    @RequestMapping(value={"/pay.jspx"}, method={RequestMethod.POST})
    public String pay(Long orderId, String code, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (orderId != null && this.manager.findById(orderId) != null) {
            Order order = this.manager.findById(orderId);
            PaymentPlugins paymentPlugins = this.paymentPluginsMng.findByCode(code);
            PrintWriter out = null;
            String aliURL = null;
            try {
                try {
                    if (!StringUtils.isBlank((String)code) && code.equals("alipayPartner")) {
                        aliURL = this.alipay(paymentPlugins, web, order, request, model);
                    } else if (!StringUtils.isBlank((String)code) && code.equals("alipay")) {
                        aliURL = this.alipayapi(paymentPlugins, web, order, request, model);
                    }
                    response.setContentType("text/html;charset=UTF-8");
                    out = response.getWriter();
                    out.print(aliURL);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    out.close();
                }
            }
            finally {
                out.close();
            }
            return null;
        }
        return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
    }

    @RequestMapping(value={"/aliReturn.jspx"})
    public String aliReturn(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            int i = 0;
            while (i < values.length) {
                valueStr = i == values.length - 1 ? String.valueOf(valueStr) + values[i] : String.valueOf(valueStr) + values[i] + ",";
                ++i;
            }
            params.put(name, valueStr);
        }
        String out_trade_no = new String(request.getParameter("out_trade_no").getBytes("ISO-8859-1"), "UTF-8");
        String trade_no = new String(request.getParameter("trade_no").getBytes("ISO-8859-1"), "UTF-8");
        String trade_status = new String(request.getParameter("trade_status").getBytes("ISO-8859-1"), "UTF-8");
        PaymentPlugins paymentPlugins = this.paymentPluginsMng.findByCode("alipayPartner");
        Long orderId = Long.parseLong(out_trade_no);
        Order order = this.manager.findById(orderId);
        if (AlipayAct.verify(params, paymentPlugins.getPartner(), paymentPlugins.getSellerKey())) {
            if (trade_status.equals("WAIT_BUYER_PAY")) {
                return FrontUtils.showMessage(request, model, "\u4ed8\u6b3e\u5931\u8d25\uff01");
            }
            if (trade_status.equals("WAIT_SELLER_SEND_GOODS")) {
                order.setPaymentStatus(2);
                order.setTradeNo(trade_no);
                order.setPaymentCode("alipayPartner");
                this.manager.updateByUpdater(order);
                return FrontUtils.showMessage(request, model, "\u4ed8\u6b3e\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u53d1\u8d27\uff01");
            }
            if (trade_status.equals("WAIT_BUYER_CONFIRM_GOODS")) {
                return FrontUtils.showMessage(request, model, "\u5df2\u53d1\u8d27\uff0c\u672a\u786e\u8ba4\u6536\u8d27\uff01");
            }
            if (trade_status.equals("TRADE_FINISHED")) {
                return FrontUtils.showMessage(request, model, "\u4ea4\u6613\u5b8c\u6210\uff01");
            }
            return FrontUtils.showMessage(request, model, "success\uff01");
        }
        return FrontUtils.showMessage(request, model, "\u4ed8\u6b3e\u5f02\u5e38\uff01");
    }

    private String alipay(PaymentPlugins paymentPlugins, Website web, Order order, HttpServletRequest request, ModelMap model) {
        String payment_type = "1";
        String notify_url = "http://" + web.getDomain() + "/aliReturn.jspx";
        String return_url = "http://" + web.getDomain() + "/aliReturn.jspx";
        String seller_email = paymentPlugins.getSellerEmail();
        String out_trade_no = order.getId().toString();
        String subject = "(" + order.getId() + ")";
        String price = String.valueOf(order.getTotal());
        String quantity = "1";
        String logistics_fee = String.valueOf(order.getFreight());
        String logistics_type = this.getLogisticsType(order);
        String logistics_payment = "BUYER_PAY";
        String body = "(" + order.getId() + ")";
        String show_url = "http://" + web.getDomain() + "/";
        String receive_name = order.getReceiveName();
        String receive_address = order.getReceiveAddress();
        String receive_zip = order.getReceiveZip();
        String receive_phone = order.getReceivePhone();
        String receive_mobile = order.getReceiveMobile();
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "create_partner_trade_by_buyer");
        sParaTemp.put("partner", paymentPlugins.getPartner());
        sParaTemp.put("_input_charset", "utf-8");
        sParaTemp.put("payment_type", payment_type);
        sParaTemp.put("notify_url", notify_url);
        sParaTemp.put("return_url", return_url);
        sParaTemp.put("seller_email", seller_email);
        sParaTemp.put("out_trade_no", out_trade_no);
        sParaTemp.put("subject", subject);
        sParaTemp.put("price", price);
        sParaTemp.put("quantity", quantity);
        sParaTemp.put("logistics_fee", logistics_fee);
        sParaTemp.put("logistics_type", logistics_type);
        sParaTemp.put("logistics_payment", logistics_payment);
        sParaTemp.put("body", body);
        sParaTemp.put("show_url", show_url);
        sParaTemp.put("receive_name", receive_name);
        sParaTemp.put("receive_address", receive_address);
        sParaTemp.put("receive_zip", receive_zip);
        sParaTemp.put("receive_phone", receive_phone);
        sParaTemp.put("receive_mobile", receive_mobile);
        String sHtmlText = AlipayAct.buildRequest(sParaTemp, paymentPlugins.getSellerKey(), "get", "\u786e\u8ba4");
        return sHtmlText;
    }

    @RequestMapping(value={"/aliReturnUrl.jspx"})
    public String aliReturndirect(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            int i = 0;
            while (i < values.length) {
                valueStr = i == values.length - 1 ? String.valueOf(valueStr) + values[i] : String.valueOf(valueStr) + values[i] + ",";
                ++i;
            }
            params.put(name, valueStr);
        }
        String out_trade_no = new String(request.getParameter("out_trade_no").getBytes("ISO-8859-1"), "UTF-8");
        String trade_no = new String(request.getParameter("trade_no").getBytes("ISO-8859-1"), "UTF-8");
        String trade_status = new String(request.getParameter("trade_status").getBytes("ISO-8859-1"), "UTF-8");
        PaymentPlugins paymentPlugins = this.paymentPluginsMng.findByCode("alipay");
        Long orderId = Long.parseLong(out_trade_no);
        Order order = this.manager.findById(orderId);
        if (AlipayAct.verify(params, paymentPlugins.getPartner(), paymentPlugins.getSellerKey())) {
            if (trade_status.equals("TRADE_FINISHED")) {
                order.setPaymentStatus(2);
                this.manager.updateByUpdater(order);
                return FrontUtils.showMessage(request, model, "\u4ed8\u6b3e\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u53d1\u8d27\uff01");
            }
            if (trade_status.equals("TRADE_SUCCESS")) {
                order.setPaymentStatus(2);
                this.manager.updateByUpdater(order);
                return FrontUtils.showMessage(request, model, "\u4ed8\u6b3e\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u53d1\u8d27\uff01");
            }
        } else {
            return FrontUtils.showMessage(request, model, "\u9a8c\u8bc1\u5931\u8d25\uff01");
        }
        return FrontUtils.showMessage(request, model, "\u4ed8\u6b3e\u5f02\u5e38\uff01");
    }

    private String alipayapi(PaymentPlugins paymentPlugins, Website web, Order order, HttpServletRequest request, ModelMap model) {
        String payment_type = "1";
        String notify_url = "http://" + web.getDomain() + "/aliReturnUrl.jspx";
        String return_url = "http://" + web.getDomain() + "/aliReturnUrl.jspx";
        String seller_email = paymentPlugins.getSellerEmail();
        String out_trade_no = order.getId().toString();
        String subject = "(" + order.getId() + ")";
        String total_fee = String.valueOf(order.getTotal());
        String body = "(" + order.getId() + ")";
        String show_url = "http://" + web.getDomain() + "/";
        String anti_phishing_key = "";
        String exter_invoke_ip = RequestUtils.getIpAddr((HttpServletRequest)request);
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "create_direct_pay_by_user");
        sParaTemp.put("partner", paymentPlugins.getPartner());
        sParaTemp.put("_input_charset", "utf-8");
        sParaTemp.put("payment_type", payment_type);
        sParaTemp.put("notify_url", notify_url);
        sParaTemp.put("return_url", return_url);
        sParaTemp.put("seller_email", seller_email);
        sParaTemp.put("out_trade_no", out_trade_no);
        sParaTemp.put("subject", subject);
        sParaTemp.put("total_fee", total_fee);
        sParaTemp.put("body", body);
        sParaTemp.put("show_url", show_url);
        sParaTemp.put("anti_phishing_key", anti_phishing_key);
        sParaTemp.put("exter_invoke_ip", exter_invoke_ip);
        String sHtmlText = AlipayAct.buildRequest(sParaTemp, paymentPlugins.getSellerKey(), "get", "\u786e\u8ba4");
        return sHtmlText;
    }

    public String getLogisticsType(Order order) {
        String logistics_type = !StringUtils.isBlank((String)order.getShipping().getLogisticsType()) ? order.getShipping().getLogisticsType() : "EXPRESS";
        return logistics_type;
    }
}

