/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.front;

import com.jspgou.cms.entity.Address;
import com.jspgou.cms.entity.Cart;
import com.jspgou.cms.entity.CartItem;
import com.jspgou.cms.entity.Order;
import com.jspgou.cms.entity.OrderItem;
import com.jspgou.cms.entity.Payment;
import com.jspgou.cms.entity.PopularityGroup;
import com.jspgou.cms.entity.PopularityItem;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductFashion;
import com.jspgou.cms.entity.Shipping;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.ShopMemberAddress;
import com.jspgou.cms.entity.base.BaseCart;
import com.jspgou.cms.manager.AddressMng;
import com.jspgou.cms.manager.CartItemMng;
import com.jspgou.cms.manager.CartMng;
import com.jspgou.cms.manager.MemberCouponMng;
import com.jspgou.cms.manager.OrderMng;
import com.jspgou.cms.manager.PaymentMng;
import com.jspgou.cms.manager.PopularityGroupMng;
import com.jspgou.cms.manager.PopularityItemMng;
import com.jspgou.cms.manager.ProductFashionMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ShippingMng;
import com.jspgou.cms.manager.ShopMemberAddressMng;
import com.jspgou.cms.service.ShoppingSvc;
import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CartAct {
    private static final Logger log = LoggerFactory.getLogger(CartAct.class);
    private static final String SHOPPING_CART = "tpl.shoppingCart";
    private static final String CHECKOUT_SHIPPING = "tpl.checkoutShipping";
    @Autowired
    private OrderMng orderMng;
    @Autowired
    private ShoppingSvc shoppingSvc;
    @Autowired
    private ProductMng productMng;
    @Autowired
    private ProductFashionMng productFashionMng;
    @Autowired
    private CartItemMng cartItemMng;
    @Autowired
    private CartMng cartMng;
    @Autowired
    private AddressMng addressMng;
    @Autowired
    private PaymentMng paymentMng;
    @Autowired
    private ShippingMng shippingMng;
    @Autowired
    private ShopMemberAddressMng shopMemberAddressMng;
    @Autowired
    private MemberCouponMng memberCouponMng;
    @Autowired
    private PopularityGroupMng popularityGroupMng;
    @Autowired
    private PopularityItemMng popularityItemMng;

    @RequestMapping(value={"/cart/shopping_cart.jspx"})
    public String shoppingCart(String backUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        Cart cart = this.shoppingSvc.getCart(member, request, response);
        List<PopularityItem> popularityItems = null;
        if (cart != null) {
            popularityItems = this.popularityItemMng.getlist(cart.getId(), null);
        }
        model.addAttribute("cart", (Object)cart);
        if (!StringUtils.isBlank((String)backUrl)) {
            model.addAttribute("backUrl", (Object)backUrl);
        }
        model.addAttribute("popularityItems", popularityItems);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)SHOPPING_CART, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/cart/add_orderItem.jspx"})
    public void addToCart(Long productId, Integer productAmount, Long fashId, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        JSONObject json = new JSONObject();
        if (member == null) {
            json.put("status", 0);
        } else {
            Product product = this.productMng.findById(productId);
            Boolean onSale = product.getOnSale();
            if (fashId == null) {
                if (productAmount > product.getStockCount()) {
                    json.put("status", 2);
                    json.put("error", (Object)"\u5e93\u5b58\u4e0d\u8db3");
                } else if (!onSale.booleanValue()) {
                    json.put("status", 2);
                    json.put("error", (Object)"\u5546\u54c1\u5df2\u7ecf\u4e0b\u67b6\uff0c\u4e0d\u80fd\u8d2d\u4e70");
                } else {
                    Cart cart = this.shoppingSvc.collectAddToCart(product, fashId, null, productAmount, true, member, web, request, response);
                    json.put("status", 1);
                    json.put("count", (Object)cart.getTotalItems());
                }
            } else {
                ProductFashion productFashion = this.productFashionMng.findById(fashId);
                if (productAmount > productFashion.getStockCount()) {
                    json.put("status", 2);
                    json.put("error", (Object)(String.valueOf(productFashion.getAttitude()) + "\u5e93\u5b58\u4e0d\u8db3"));
                } else if (!onSale.booleanValue()) {
                    json.put("status", 2);
                    json.put("error", (Object)"\u5546\u54c1\u5df2\u7ecf\u4e0b\u67b6\uff0c\u4e0d\u80fd\u8d2d\u4e70");
                } else {
                    Cart cart = this.shoppingSvc.collectAddToCart(product, fashId, null, productAmount, true, member, web, request, response);
                    json.put("status", 1);
                    json.put("count", (Object)cart.getTotalItems());
                }
            }
        }
        log.info("add to cart productId={}, count={}", (Object)productId, (Object)productAmount);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/cart/add_popularity.jspx"})
    public void addToPopularity(Long popularityId, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        JSONObject json = new JSONObject();
        if (member == null) {
            json.put("status", 0);
        } else if (this.getinventory(popularityId)) {
            BaseCart cart = null;
            for (Product product : this.popularityGroupMng.findById(popularityId).getProducts()) {
                cart = this.shoppingSvc.collectAddToCart(product, null, popularityId, 1, true, member, web, request, response);
            }
            this.popularityItemMng.save((Cart)cart, popularityId);
            json.put("status", 1);
            json.put("count", (Object)cart.getTotalItems());
        } else {
            json.put("status", 2);
            json.put("error", (Object)"\u5e93\u5b58\u4e0d\u8db3");
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    public boolean getinventory(Long popularityId) {
        for (Product product : this.popularityGroupMng.findById(popularityId).getProducts()) {
            if (1 <= product.getStockCount()) continue;
            return false;
        }
        return true;
    }

    @RequestMapping(value={"/cart/add_orderItem1.jspx"})
    public String orderAddToCart(Long orderId, Boolean isAdd, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        Order order = this.orderMng.findById(orderId);
        Product product = null;
        Integer productAmount = 0;
        Long fashId = null;
        Cart cart = null;
        for (OrderItem item : order.getItems()) {
            product = item.getProduct();
            productAmount = item.getCount();
            if (item.getProductFash() != null) {
                fashId = item.getProductFash().getId();
            }
            cart = this.shoppingSvc.collectAddToCart(product, fashId, null, productAmount, true, member, web, request, response);
        }
        return "redirect:shopping_cart.jspx";
    }

    @RequestMapping(value={"/cart/ajaxUpdateCartItem.jspx"})
    public void ajaxUpdateCartItem(Long cartItemId, Integer count, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        ShopMember member = MemberThread.get();
        JSONObject json = new JSONObject();
        if (member == null) {
            json.put("status", 0);
        }
        CartItem cartItem = this.cartItemMng.findById(cartItemId);
        cartItem.setCount(count);
        cartItem.setScore(cartItem.getProduct().getScore() * count);
        this.cartItemMng.updateByUpdater(cartItem);
        log.info("update to cartItem cartItemId={}", (Object)cartItemId);
        json.put("status", 1);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/cart/ajaxDeleteCartItem.jspx"})
    public void ajaxDeleteCartItem(Long cartItemId, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        ShopMember member = MemberThread.get();
        JSONObject json = new JSONObject();
        if (member == null) {
            json.put("status", 0);
        }
        CartItem cartItem = this.cartItemMng.findById(cartItemId);
        Cart cart = cartItem.getCart();
        PopularityGroup popularityGroup = cartItem.getPopularityGroup();
        cart.getItems().remove(cartItem);
        cart.setTotalItems(cart.calTotalItem());
        this.cartMng.update(cart);
        if (cart != null && popularityGroup != null) {
            List<CartItem> list = this.cartItemMng.getlist(cart.getId(), popularityGroup.getId());
            list.remove(cartItem);
            for (CartItem item : list) {
                item.setPopularityGroup(null);
                this.cartItemMng.updateByUpdater(item);
            }
            this.update(cart, popularityGroup);
        }
        log.info("delete to cartItem cartItemId={}", (Object)cartItemId);
        json.put("status", 1);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    public void update(Cart cart, PopularityGroup popularityGroup) {
        PopularityItem popularityItem;
        if (popularityGroup != null && (popularityItem = this.popularityItemMng.findById(cart.getId(), popularityGroup.getId())) != null) {
            this.popularityItemMng.deleteById(popularityItem.getId());
        }
    }

    @RequestMapping(value={"/cart/checkStockCount.jspx"})
    public void checkStockCount(Long productId, String productFashionId, Integer count, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        ShopMember member = MemberThread.get();
        JSONObject json = new JSONObject();
        boolean check = true;
        if (member == null) {
            json.put("status", 0);
        } else if (this.productMng.findById(productId) == null) {
            check = false;
            json.put("status", 2);
            json.put("error", (Object)"\u8d2d\u7269\u8f66\u4e2d\u542b\u6709\u5546\u54c1\u5df2\u7ecf\u88ab\u5220\u9664\u7684\u60c5\u51b5\u3002");
        } else {
            Product product = this.productMng.findById(productId);
            Boolean onSale = product.getOnSale();
            if (productFashionId.equals("undefined")) {
                if (count > product.getStockCount()) {
                    check = false;
                    json.put("status", 2);
                    json.put("error", (Object)(String.valueOf(product.getName()) + "\u8be5\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\u3002"));
                } else if (!onSale.booleanValue()) {
                    check = false;
                    json.put("status", 2);
                    json.put("error", (Object)(String.valueOf(product.getName()) + "\u5546\u54c1\u5df2\u7ecf\u4e0b\u67b6\uff0c\u4e0d\u80fd\u8d2d\u4e70"));
                }
            } else if (this.productFashionMng.findById(Long.parseLong(productFashionId)) == null) {
                check = false;
                json.put("status", 2);
                json.put("error", (Object)"\u8d2d\u7269\u8f66\u4e2d\u542b\u6709\u6b3e\u5f0f\u5546\u54c1\u5df2\u7ecf\u88ab\u5220\u9664\u7684\u60c5\u51b5\u3002");
            } else {
                ProductFashion productFashion = this.productFashionMng.findById(Long.parseLong(productFashionId));
                if (count > productFashion.getStockCount()) {
                    check = false;
                    json.put("error", (Object)(String.valueOf(product.getName()) + productFashion.getAttitude() + "\u8be5\u6b3e\u5f0f\u5e93\u5b58\u4e0d\u8db3\u3002"));
                    json.put("status", 2);
                } else if (!onSale.booleanValue()) {
                    check = false;
                    json.put("status", 2);
                    json.put("error", (Object)(String.valueOf(product.getName()) + "\u5546\u54c1\u5df2\u7ecf\u4e0b\u67b6\uff0c\u4e0d\u80fd\u8d2d\u4e70"));
                }
            }
        }
        if (check) {
            json.put("status", 1);
        }
        log.info("Submit shopping cart productId={}, count={}", (Object)productId, (Object)count);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/cart/ajaxtotalDeliveryFee.jspx"})
    public void ajaxtotalDeliveryFee(Long deliveryMethod, Double weight, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        ShopMember member = MemberThread.get();
        JSONObject json = new JSONObject();
        if (member == null) {
            json.put("status", 0);
        }
        Shipping shipping = this.shippingMng.findById(deliveryMethod);
        Double freight = shipping.calPrice(weight);
        json.put("status", 1);
        json.put("freight", (Object)freight);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/cart/checkout_shipping.jspx"})
    public String shippingInput(Long[] cart2Checkbox, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Set<CartItem> items;
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        Cart cart = this.shoppingSvc.getCart(member.getId());
        if (cart == null) {
            return "redirect:shopping_cart.jspx";
        }
        List<PopularityItem> popularityItems = null;
        Double popularityPrice = 0.0;
        if (cart != null) {
            popularityItems = this.popularityItemMng.getlist(cart.getId(), null);
            for (PopularityItem popularityItem : popularityItems) {
                popularityPrice = popularityPrice + popularityItem.getPopularityGroup().getPrivilege() * (double)popularityItem.getCount().intValue();
            }
        }
        if ((items = this.getItems(cart2Checkbox, cart)) == null) {
            return "redirect:/cart/shopping_cart.jspx";
        }
        for (CartItem item : items) {
            if (item != null) continue;
            return "redirect:/cart/shopping_cart.jspx";
        }
        Double price = this.getPrice(items);
        List<Shipping> splist = this.shippingMng.getList(web.getId(), true);
        List<ShopMemberAddress> smalist = this.shopMemberAddressMng.getList(member.getId());
        List<Address> plist = this.addressMng.getListById(null);
        List<Payment> paylist = this.paymentMng.getList(1L, true);
        model.addAttribute("memberCouponlist", this.memberCouponMng.getList(member.getId(), new BigDecimal(price)));
        model.addAttribute("items", this.getItems(cart2Checkbox, cart));
        model.addAttribute("smalist", smalist);
        model.addAttribute("plist", plist);
        model.addAttribute("paylist", paylist);
        model.addAttribute("splist", splist);
        model.addAttribute("popularityPrice", (Object)popularityPrice);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)CHECKOUT_SHIPPING, (Object[])new Object[0]));
    }

    public Set<CartItem> getItems(Long[] cart2Checkbox, Cart cart) {
        HashSet<CartItem> items = new HashSet();
        if (cart2Checkbox != null) {
            Long[] longArray = cart2Checkbox;
            int n = cart2Checkbox.length;
            int n2 = 0;
            while (n2 < n) {
                Long id = longArray[n2];
                items.add(this.cartItemMng.findById(id));
                ++n2;
            }
        } else {
            items = cart.getItems();
        }
        return items;
    }

    public Double getPrice(Set<CartItem> items) {
        Double price = 0.0;
        for (CartItem item : items) {
            price = item.getProductFash() != null ? Double.valueOf(price + item.getProductFash().getSalePrice() * (double)item.getCount().intValue()) : Double.valueOf(price + item.getProduct().getSalePrice() * (double)item.getCount().intValue());
        }
        return price;
    }
}

