/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.front;

import com.jspgou.cms.entity.Coupon;
import com.jspgou.cms.entity.MemberCoupon;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.manager.CouponMng;
import com.jspgou.cms.manager.MemberCouponMng;
import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.front.URLHelper;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class CouponAct {
    @Autowired
    private CouponMng manager;
    @Autowired
    private MemberCouponMng memberCouponMng;

    @RequestMapping(value={"/coupon*.jspx"}, method={RequestMethod.GET})
    public String list(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        int pageNo = URLHelper.getPageNo((HttpServletRequest)request);
        ShopFrontHelper.setCommonData(request, model, web, pageNo);
        ShopFrontHelper.setDynamicPageData(request, model, web, RequestUtils.getLocation((HttpServletRequest)request), "coupon", ".jspx", pageNo);
        return web.getTplSys("coupon", MessageResolver.getMessage((HttpServletRequest)request, (String)"tpl.coupon", (Object[])new Object[0]));
    }

    @RequestMapping(value={"/getcoupon.jspx"})
    public void fetchGift(Long id, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        Date newdate = new Date();
        JSONObject json = new JSONObject();
        if (member == null) {
            json.put("status", 0);
        } else if (id == null || this.manager.findById(id) == null) {
            json.put("status", 2);
            json.put("error", (Object)"\u53c2\u6570\u6709\u8bef");
        } else if (this.memberCouponMng.findByCoupon(member.getId(), id) != null) {
            json.put("status", 2);
            json.put("error", (Object)"\u60a8\u5df2\u9886\u53d6\u8fc7\u8be5\u4f18\u60e0\u5238\u4e86");
        } else if (!this.manager.findById(id).getIsusing().booleanValue()) {
            json.put("status", 2);
            json.put("error", (Object)"\u8be5\u4f18\u60e0\u5238\u5df2\u505c\u7528");
        } else if (!newdate.before(this.manager.findById(id).getCouponEndTime())) {
            json.put("status", 2);
            json.put("error", (Object)"\u8be5\u4f18\u60e0\u5238\u5df2\u8fc7\u671f");
        } else if (this.manager.findById(id).getCouponCount() < 1) {
            json.put("status", 2);
            json.put("error", (Object)"\u8be5\u4f18\u60e0\u5238\u5df2\u9886\u5b8c");
        } else {
            Coupon coupon = this.manager.findById(id);
            MemberCoupon memberCoupon = new MemberCoupon();
            memberCoupon.setCoupon(coupon);
            memberCoupon.setMember(member);
            memberCoupon.setIsuse(false);
            coupon.setCouponCount(coupon.getCouponCount() - 1);
            this.memberCouponMng.save(memberCoupon);
            this.manager.update(coupon);
            json.put("status", 1);
        }
        ShopFrontHelper.setCommonData(request, model, web, 1);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }
}

