/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.front;

import com.jspgou.cms.entity.Brand;
import com.jspgou.cms.entity.Category;
import com.jspgou.cms.entity.Exended;
import com.jspgou.cms.entity.ExendedItem;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductStandard;
import com.jspgou.cms.entity.ShopArticle;
import com.jspgou.cms.entity.ShopChannel;
import com.jspgou.cms.entity.StandardType;
import com.jspgou.cms.manager.BrandMng;
import com.jspgou.cms.manager.CategoryMng;
import com.jspgou.cms.manager.ExendedMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ProductStandardMng;
import com.jspgou.cms.manager.ShopArticleMng;
import com.jspgou.cms.manager.ShopChannelMng;
import com.jspgou.cms.manager.StandardTypeMng;
import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Global;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import com.jspgou.core.web.front.FrontHelper;
import com.jspgou.core.web.front.URLHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class DynamicPageAct {
    public static final String TPL_INDEX = "tpl.index";
    private static final String BRAND = "tpl.brand";
    private static final String BRAND_DETAIL = "tpl.brandDetail";
    @Autowired
    private CategoryMng categoryMng;
    @Autowired
    private ProductMng productMng;
    @Autowired
    private ShopChannelMng shopChannelMng;
    @Autowired
    private ShopArticleMng shopArticleMng;
    @Autowired
    private BrandMng brandMng;
    @Autowired
    private StandardTypeMng standardTypeMng;
    @Autowired
    private ProductStandardMng productStandardMng;
    @Autowired
    private ExendedMng exendedMng;

    @RequestMapping(value={"/index.jhtml"}, method={RequestMethod.GET})
    public String indexForWeblogic(HttpServletRequest request, ModelMap model) {
        return this.index(request, model);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTemplate("index", MessageResolver.getMessage((HttpServletRequest)request, (String)TPL_INDEX, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/**/*.*"}, method={RequestMethod.GET})
    public String excute(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        String url = request.getRequestURL().toString();
        Global global = SiteUtils.getWeb((HttpServletRequest)request).getGlobal();
        model.addAttribute("global", (Object)global);
        URLHelper.PageInfo info = URLHelper.getPageInfo((HttpServletRequest)request);
        int pageNo = URLHelper.getPageNo((HttpServletRequest)request);
        String queryString = request.getQueryString();
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopFrontHelper.setDynamicPageData(request, model, web, url, info.getHrefFormer(), info.getHrefLatter(), pageNo);
        String[] paths = URLHelper.getPaths((HttpServletRequest)request);
        String[] params = URLHelper.getParams((HttpServletRequest)request);
        int len = paths.length;
        if (len == 1) {
            return this.channel(paths[0], params, pageNo, queryString, url, web, request, response, model);
        }
        if (len == 2) {
            if (paths[1].equals("index")) {
                return this.channel(paths[0], params, pageNo, queryString, url, web, request, response, model);
            }
            try {
                Long id = Long.parseLong(paths[1]);
                return this.content(paths[0], id, params, pageNo, queryString, url, web, request, response, model);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
    }

    public String channel(String path, String[] params, int pageNo, String queryString, String url, Website web, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Category category = this.categoryMng.getByPath(web.getId(), path);
        if (category != null) {
            List<Exended> exendeds = this.exendedMng.getList(category.getType().getId());
            HashMap<String, Set<ExendedItem>> map = new HashMap<String, Set<ExendedItem>>();
            HashMap<String, Exended> map1 = new HashMap<String, Exended>();
            int num = exendeds.size();
            int i = 0;
            while (i < num) {
                map.put(exendeds.get(i).getId().toString(), exendeds.get(i).getItems());
                map1.put(exendeds.get(i).getId().toString(), exendeds.get(i));
                ++i;
            }
            model.addAttribute("brandId", (Object)this.getBrandId(request));
            model.addAttribute("map", map);
            model.addAttribute("map1", map1);
            model.addAttribute("fields", (Object)this.getNames(request));
            model.addAttribute("zhis", (Object)this.getValues(request));
            model.addAttribute("category", (Object)category);
            model.addAttribute("pageSize", (Object)this.getpageSize(request));
            model.addAttribute("names", (Object)this.getName(request));
            model.addAttribute("values", (Object)this.getValue(request));
            model.addAttribute("isShow", (Object)this.getIsShow(request));
            model.addAttribute("orderBy", (Object)this.getOrderBy(request));
            return category.getTplChannelRel();
        }
        ShopChannel channel = this.shopChannelMng.getByPath(web.getId(), path);
        if (channel != null) {
            model.addAttribute("channel", (Object)channel);
            return channel.getTplChannelRel();
        }
        return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
    }

    public String content(String chnlName, Long id, String[] params, int pageNo, String queryString, String url, Website web, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Category category = this.categoryMng.getByPath(web.getId(), chnlName);
        if (category != null) {
            Product product = this.productMng.findById(id);
            if (product != null) {
                if (product.getProductFashion() != null) {
                    String[] arr = null;
                    arr = product.getProductFashion().getNature().split("_");
                    model.addAttribute("arr", (Object)arr);
                }
                List<ProductStandard> psList = this.productStandardMng.findByProductId(id);
                List<StandardType> standardTypeList = this.standardTypeMng.getList((Long)category.getId());
                this.productMng.updateViewCount(product);
                model.addAttribute("standardTypeList", standardTypeList);
                model.addAttribute("psList", psList);
                model.addAttribute("category", (Object)category);
                model.addAttribute("product", (Object)product);
                return category.getTplContentRel();
            }
            return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        ShopArticle article = this.shopArticleMng.findById(id);
        if (article != null) {
            ShopChannel channel = article.getChannel();
            model.addAttribute("article", (Object)article);
            model.addAttribute("channel", (Object)channel);
            return channel.getTplContentRel();
        }
        return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
    }

    @RequestMapping(value={"/brand.jspx"}, method={RequestMethod.GET})
    public String brand(Long id, HttpServletRequest request, ModelMap model) {
        String tpl;
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateBrand(id, request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        if (id != null) {
            model.addAttribute("brand", (Object)this.brandMng.findById(id));
            tpl = MessageResolver.getMessage((HttpServletRequest)request, (String)BRAND_DETAIL, (Object[])new Object[0]);
        } else {
            tpl = MessageResolver.getMessage((HttpServletRequest)request, (String)BRAND, (Object[])new Object[0]);
        }
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("shop", tpl);
    }

    public Integer getBrandId(HttpServletRequest request) {
        String brandId = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"brandId");
        Integer id = null;
        if (!StringUtils.isBlank((String)brandId)) {
            id = Integer.parseInt(brandId);
        }
        return id;
    }

    public Integer getpageSize(HttpServletRequest request) {
        String pageSize = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"pageSize");
        Integer pagesize = null;
        if (!StringUtils.isBlank((String)pageSize)) {
            pagesize = Integer.parseInt(pageSize);
        }
        if (pagesize == null) {
            pagesize = 12;
        }
        return pagesize;
    }

    public Integer getIsShow(HttpServletRequest request) {
        String isShow = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"isShow");
        Integer isshow = null;
        if (!StringUtils.isBlank((String)isShow)) {
            isshow = Integer.parseInt(isShow);
        }
        if (isshow == null) {
            isshow = 0;
        }
        return isshow;
    }

    public Integer getOrderBy(HttpServletRequest request) {
        String orderBy = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"orderBy");
        Integer orderby = null;
        if (!StringUtils.isBlank((String)orderBy)) {
            orderby = Integer.parseInt(orderBy);
        }
        if (orderby == null) {
            orderby = 0;
        }
        return orderby;
    }

    public String[] getNames(HttpServletRequest request) {
        Map attr = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"exended_");
        ArrayList li = new ArrayList(attr.keySet());
        String name = "";
        int i = 0;
        while (i < li.size()) {
            name = i + 1 == li.size() ? String.valueOf(name) + (String)li.get(i) : String.valueOf(name) + (String)li.get(i) + ",";
            ++i;
        }
        String[] names = StringUtils.split((String)name, (char)',');
        return names;
    }

    public String[] getValues(HttpServletRequest request) {
        Map attr = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"exended_");
        ArrayList li = new ArrayList(attr.keySet());
        String value = "";
        int i = 0;
        while (i < li.size()) {
            value = i + 1 == li.size() ? (StringUtils.isBlank((String)((String)attr.get(li.get(i)))) ? String.valueOf(value) + "0" : String.valueOf(value) + (String)attr.get(li.get(i))) : (StringUtils.isBlank((String)((String)attr.get(li.get(i)))) ? String.valueOf(value) + "0," : String.valueOf(value) + (String)attr.get(li.get(i)) + ",");
            ++i;
        }
        String[] values = StringUtils.split((String)value, (char)',');
        return values;
    }

    public String getName(HttpServletRequest request) {
        Map attr = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"exended_");
        ArrayList li = new ArrayList(attr.keySet());
        String name = "";
        int i = 0;
        while (i < li.size()) {
            name = i + 1 == li.size() ? String.valueOf(name) + (String)li.get(i) : String.valueOf(name) + (String)li.get(i) + ",";
            ++i;
        }
        return name;
    }

    public String getValue(HttpServletRequest request) {
        Map attr = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"exended_");
        ArrayList li = new ArrayList(attr.keySet());
        String value = "";
        int i = 0;
        while (i < li.size()) {
            value = i + 1 == li.size() ? (StringUtils.isBlank((String)((String)attr.get(li.get(i)))) ? String.valueOf(value) + "0" : String.valueOf(value) + (String)attr.get(li.get(i))) : (StringUtils.isBlank((String)((String)attr.get(li.get(i)))) ? String.valueOf(value) + "0," : String.valueOf(value) + (String)attr.get(li.get(i)) + ",");
            ++i;
        }
        return value;
    }

    private WebErrors validateBrand(Long id, HttpServletRequest request) {
        Brand brand;
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (id != null && errors.ifNotExist((Object)(brand = this.brandMng.findById(id)), Brand.class, (Serializable)id)) {
            return errors;
        }
        return errors;
    }
}

