/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.front;

import com.jspgou.cms.entity.Address;
import com.jspgou.cms.entity.Gift;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.ShopMemberAddress;
import com.jspgou.cms.manager.AddressMng;
import com.jspgou.cms.manager.GiftExchangeMng;
import com.jspgou.cms.manager.GiftMng;
import com.jspgou.cms.manager.ShopMemberAddressMng;
import com.jspgou.cms.web.FrontUtils;
import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import com.jspgou.core.web.front.FrontHelper;
import com.jspgou.core.web.front.URLHelper;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class GiftAct {
    @Autowired
    private GiftMng manager;
    @Autowired
    private ShopMemberAddressMng shopMemberAddressMng;
    @Autowired
    private AddressMng addressMng;
    @Autowired
    private GiftExchangeMng giftExchangeMng;

    @RequestMapping(value={"/gift*.jspx"}, method={RequestMethod.GET})
    public String list(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        int pageNo = URLHelper.getPageNo((HttpServletRequest)request);
        ShopFrontHelper.setCommonData(request, model, web, pageNo);
        ShopFrontHelper.setDynamicPageData(request, model, web, RequestUtils.getLocation((HttpServletRequest)request), "gift", ".jspx", pageNo);
        return web.getTplSys("gift", MessageResolver.getMessage((HttpServletRequest)request, (String)"tpl.gift", (Object[])new Object[0]));
    }

    @RequestMapping(value={"/present.jspx"}, method={RequestMethod.GET})
    public String present(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (id == null || this.manager.findById(id) == null) {
            return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        model.addAttribute("gift", (Object)this.manager.findById(id));
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("gift", MessageResolver.getMessage((HttpServletRequest)request, (String)"tpl.present", (Object[])new Object[0]));
    }

    @RequestMapping(value={"/fetchGift.jspx"})
    public void fetchGift(Long giftId, Integer giftNumb, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws JSONException {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        JSONObject json = new JSONObject();
        if (member == null) {
            json.put("status", 0);
        } else {
            Gift gift = this.manager.findById(giftId);
            if (giftNumb > gift.getGiftStock()) {
                json.put("status", 2);
                json.put("error", (Object)"\u5e93\u5b58\u4e0d\u8db3");
            }
            if ((long)gift.getGiftScore().intValue() * Long.parseLong(giftNumb.toString()) > (long)member.getScore().intValue()) {
                json.put("status", 2);
                json.put("error", (Object)"\u79ef\u5206\u4e0d\u8db3");
            } else {
                json.put("status", 1);
            }
        }
        ShopFrontHelper.setCommonData(request, model, web, 1);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/exchange.jspx"})
    public String shippingInput(Long id, Integer count, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:login.jspx";
        }
        WebErrors errors = this.validateGiftView(id, request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        Gift gift = this.manager.findById(id);
        if (count > gift.getGiftStock()) {
            return FrontUtils.showMessage(request, model, "\u5e93\u5b58\u4e0d\u8db3");
        }
        if ((long)gift.getGiftScore().intValue() * Long.parseLong(count.toString()) > (long)member.getScore().intValue()) {
            return FrontUtils.showMessage(request, model, "\u79ef\u5206\u4e0d\u8db3");
        }
        model.addAttribute("gift", (Object)gift);
        model.addAttribute("count", (Object)count);
        model.addAttribute("totalScore", (Object)((long)gift.getGiftScore().intValue() * Long.parseLong(count.toString())));
        List<ShopMemberAddress> smalist = this.shopMemberAddressMng.getList(member.getId());
        model.addAttribute("smalist", smalist);
        List<Address> plist = this.addressMng.getListById(null);
        model.addAttribute("plist", plist);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("gift", MessageResolver.getMessage((HttpServletRequest)request, (String)"tpl.exchange", (Object[])new Object[0]));
    }

    @RequestMapping(value={"/create_exchange.jspx"}, method={RequestMethod.POST})
    public String createExchange(Long deliveryInfo, Long id, Integer count, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:login.jspx";
        }
        WebErrors errors = this.validateGiftView(id, request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        Gift gift = this.manager.findById(id);
        if (count > gift.getGiftStock()) {
            return FrontUtils.showMessage(request, model, "\u5e93\u5b58\u4e0d\u8db3");
        }
        if ((long)gift.getGiftScore().intValue() * Long.parseLong(count.toString()) > (long)member.getScore().intValue()) {
            return FrontUtils.showMessage(request, model, "\u79ef\u5206\u4e0d\u8db3");
        }
        ShopMemberAddress shopMemberAddress = this.shopMemberAddressMng.findById(deliveryInfo);
        this.giftExchangeMng.save(gift, shopMemberAddress, member, count);
        return FrontUtils.showMessage(request, model, "\u5151\u6362\u6210\u529f");
    }

    private WebErrors validateGiftView(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifNull((Object)id, "id")) {
            return errors;
        }
        Gift gift = this.manager.findById(id);
        if (errors.ifNotExist((Object)gift, Gift.class, (Serializable)id)) {
            return errors;
        }
        return errors;
    }
}

