/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.front;

import com.jspgou.cms.entity.Cart;
import com.jspgou.cms.entity.Order;
import com.jspgou.cms.entity.OrderItem;
import com.jspgou.cms.entity.OrderReturn;
import com.jspgou.cms.entity.Payment;
import com.jspgou.cms.entity.PaymentPlugins;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ProductFashion;
import com.jspgou.cms.entity.Shipping;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.ShopScore;
import com.jspgou.cms.manager.OrderMng;
import com.jspgou.cms.manager.OrderReturnMng;
import com.jspgou.cms.manager.PaymentMng;
import com.jspgou.cms.manager.PaymentPluginsMng;
import com.jspgou.cms.manager.ProductFashionMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ShippingMng;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.cms.manager.ShopScoreMng;
import com.jspgou.cms.service.ShoppingSvc;
import com.jspgou.cms.web.FrontUtils;
import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.security.annotation.Secured;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import com.jspgou.core.web.front.FrontHelper;
import com.jspgou.core.web.front.URLHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Secured
@Controller
public class OrderAct {
    private static final String MY_ORDER = "tpl.myOrder";
    private static final String MY_RETURN_ORDER = "tpl.myReturnOrder";
    private static final String MY_ORDER_VIEW = "tpl.myOrderView";
    private static final String SUCCESSFULLY_ORDER = "tpl.successfullyOrder";
    private static final String CHECKOUT_SHIPPING = "tpl.checkoutShipping";
    @Autowired
    private OrderMng manager;
    @Autowired
    private ShippingMng shippingMng;
    @Autowired
    private PaymentMng paymentMng;
    @Autowired
    private ShoppingSvc shoppingSvc;
    @Autowired
    private PaymentPluginsMng paymentPluginsMng;
    @Autowired
    private ProductMng productMng;
    @Autowired
    private ProductFashionMng productFashionMng;
    @Autowired
    private ShopMemberMng shopMemberMng;
    @Autowired
    private ShopScoreMng shopScoreMng;
    @Autowired
    private OrderReturnMng orderReturnMng;

    @RequestMapping(value={"/order/myorder*.jspx"})
    public String myOrder(Integer status, String code, String userName, Long paymentId, Long shippingId, String startTime, String endTime, Double startOrderTotal, Double endOrderTotal, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        if (StringUtils.isBlank((String)userName)) {
            userName = null;
        }
        if (StringUtils.isBlank((String)startTime)) {
            startTime = null;
        }
        if (StringUtils.isBlank((String)endTime)) {
            endTime = null;
        }
        List<Shipping> shippingList = this.shippingMng.getList(web.getId(), true);
        List<Payment> paymentList = this.paymentMng.getList(web.getId(), true);
        model.addAttribute("historyProductIds", (Object)this.getHistoryProductIds(request));
        model.addAttribute("paymentList", paymentList);
        model.addAttribute("shippingList", shippingList);
        model.addAttribute("status", (Object)status);
        model.addAttribute("code", (Object)code);
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("startTime", (Object)startTime);
        model.addAttribute("endTime", (Object)endTime);
        model.addAttribute("paymentId", (Object)paymentId);
        model.addAttribute("shippingId", (Object)shippingId);
        model.addAttribute("startOrderTotal", (Object)startOrderTotal);
        model.addAttribute("endOrderTotal", (Object)endOrderTotal);
        Integer pageNo = URLHelper.getPageNo((HttpServletRequest)request);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        ShopFrontHelper.setDynamicPageData(request, model, web, "", "myorder", ".jspx", pageNo);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)MY_ORDER, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/order/myOrderView.jspx"})
    public String myOrderView(Long orderId, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        WebErrors errors = this.validateOrderView(orderId, member, request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        Order order = this.manager.findById(orderId);
        model.addAttribute("order", (Object)order);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)MY_ORDER_VIEW, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/order/order_shipping.jspx"})
    public String orderShipping(Long deliveryInfo, Long shippingMethodId, Long paymentMethodId, Integer[] cartCountId, Long[] cartProductId, Long[] cartItemId, String comments, String memberCouponId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        String url = null;
        boolean createOrder = true;
        if (cartCountId != null) {
            Integer[] integerArray = cartCountId;
            int n = cartCountId.length;
            int n2 = 0;
            while (n2 < n) {
                Integer cId = integerArray[n2];
                Long[] longArray = cartProductId;
                int n3 = cartProductId.length;
                int n4 = 0;
                while (n4 < n3) {
                    Long pId = longArray[n4];
                    if (this.productMng.findById(pId) == null) {
                        createOrder = false;
                        ShopFrontHelper.setCommonData(request, model, web, 1);
                        url = FrontUtils.showMessage(request, model, "\u542b\u6709\u5546\u54c1\u5df2\u88ab\u5220\u9664\u7684\u60c5\u51b5,\u4e0d\u80fd\u63d0\u4ea4\u8ba2\u5355\uff0c\u8df3\u8f6c\u56de\u63d0\u4ea4\u8ba2\u5355\u9875\u9762");
                    } else {
                        Product product = this.productMng.findById(pId);
                        Boolean onSale = product.getOnSale();
                        Long productFashionId = null;
                        if (product.getProductFashion() != null) {
                            productFashionId = product.getProductFashion().getId();
                        }
                        if (productFashionId == null) {
                            if (cId > product.getStockCount()) {
                                createOrder = false;
                                ShopFrontHelper.setCommonData(request, model, web, 1);
                                url = FrontUtils.showMessage(request, model, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u8df3\u8f6c\u56de\u63d0\u4ea4\u8ba2\u5355\u9875\u9762");
                            } else if (!onSale.booleanValue()) {
                                createOrder = false;
                                ShopFrontHelper.setCommonData(request, model, web, 1);
                                url = FrontUtils.showMessage(request, model, "\u5546\u54c1\u5df2\u7ecf\u4e0b\u67b6,\u8df3\u8f6c\u56de\u63d0\u4ea4\u8ba2\u5355\u9875\u9762");
                            }
                        } else if (this.productFashionMng.findById(productFashionId) == null) {
                            createOrder = false;
                            ShopFrontHelper.setCommonData(request, model, web, 1);
                            url = FrontUtils.showMessage(request, model, "\u542b\u6709\u6b3e\u5f0f\u5546\u54c1\u5df2\u88ab\u5220\u9664\u7684\u60c5\u51b5,\u4e0d\u80fd\u63d0\u4ea4\u8ba2\u5355\uff0c\u8df3\u8f6c\u56de\u63d0\u4ea4\u8ba2\u5355\u9875\u9762");
                        } else {
                            ProductFashion productFashion = this.productFashionMng.findById(productFashionId);
                            if (cId > productFashion.getStockCount()) {
                                createOrder = false;
                                ShopFrontHelper.setCommonData(request, model, web, 1);
                                url = FrontUtils.showMessage(request, model, "\u8be5\u6b3e\u5f0f\u5e93\u5b58\u4e0d\u8db3,\u8df3\u8f6c\u56de\u63d0\u4ea4\u8ba2\u5355\u9875\u9762");
                            } else if (!onSale.booleanValue()) {
                                createOrder = false;
                                ShopFrontHelper.setCommonData(request, model, web, 1);
                                url = FrontUtils.showMessage(request, model, "\u8be5\u6b3e\u5f0f\u5546\u54c1\u5df2\u7ecf\u4e0b\u67b6,\u8df3\u8f6c\u56de\u63d0\u4ea4\u8ba2\u5355\u9875\u9762");
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            if (createOrder) {
                Order order = null;
                Cart cart = this.shoppingSvc.getCart(member.getId());
                if (cart != null) {
                    order = this.manager.createOrder(cart, cartItemId, shippingMethodId, deliveryInfo, paymentMethodId, comments, request.getRemoteAddr(), member, web.getId(), memberCouponId);
                }
                this.shoppingSvc.clearCookie(request, response);
                List<PaymentPlugins> list = this.paymentPluginsMng.getList();
                model.addAttribute("list", list);
                model.addAttribute("order", (Object)order);
                ShopFrontHelper.setCommonData(request, model, web, 1);
                url = web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)SUCCESSFULLY_ORDER, (Object[])new Object[0]));
            }
        } else {
            return "redirect:../cart/checkout_shipping.jspx";
        }
        return url;
    }

    @RequestMapping(value={"/order/deleteOrder.jspx"})
    public void deleteOrder(Long orderId, HttpServletRequest request, HttpServletResponse response) throws JSONException {
        JSONObject json = new JSONObject();
        if (orderId != null) {
            Order order = this.manager.findById(orderId);
            order.getItems().clear();
            this.manager.deleteById(orderId);
        }
        json.put("success", true);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/order/abolishOrder.jspx"})
    public void abolishOrder(Long orderId, HttpServletRequest request, HttpServletResponse response) throws JSONException {
        JSONObject json = new JSONObject();
        ShopMember member = MemberThread.get();
        if (orderId != null) {
            Order order = this.manager.findById(orderId);
            order.setStatus(3);
            Set<OrderItem> set = order.getItems();
            for (OrderItem item : set) {
                Product product = item.getProduct();
                if (item.getProductFash() != null) {
                    ProductFashion fashion = item.getProductFash();
                    fashion.setStockCount(fashion.getStockCount() + item.getCount());
                    product.setStockCount(product.getStockCount() + item.getCount());
                    this.productFashionMng.update(fashion);
                } else {
                    product.setStockCount(product.getStockCount() + item.getCount());
                }
                this.productMng.updateByUpdater(product);
            }
            member.setFreezeScore(member.getFreezeScore() - order.getScore());
            this.shopMemberMng.update(member);
            List<ShopScore> list = this.shopScoreMng.getlist(Long.toString(order.getCode()));
            for (ShopScore s : list) {
                this.shopScoreMng.deleteById(s.getId());
            }
            this.manager.updateByUpdater(order);
        }
        json.put("success", true);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/order/accomplishOrder.jspx"})
    public void accomplishOrder(Long orderId, HttpServletRequest request, HttpServletResponse response) throws JSONException {
        JSONObject json = new JSONObject();
        ShopMember member = MemberThread.get();
        if (orderId != null) {
            Order order = this.manager.findById(orderId);
            order.setStatus(4);
            member.setFreezeScore(member.getFreezeScore() - order.getScore());
            member.setScore(member.getScore() + order.getScore());
            this.shopMemberMng.update(member);
            List<ShopScore> list = this.shopScoreMng.getlist(Long.toString(order.getCode()));
            for (ShopScore s : list) {
                s.setStatus(true);
                this.shopScoreMng.update(s);
            }
            this.manager.updateliRun(orderId);
            this.manager.updateByUpdater(order);
        }
        json.put("success", true);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/order/order_payAgain.jspx"})
    public String payOrderAgain(Long orderId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        WebErrors errors = this.validateOrderView(orderId, member, request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        this.shoppingSvc.clearCookie(request, response);
        Order order = this.manager.findById(orderId);
        List<PaymentPlugins> list = this.paymentPluginsMng.getList();
        model.addAttribute("list", list);
        model.addAttribute("order", (Object)order);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)SUCCESSFULLY_ORDER, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/order/myReturnOrder*.jspx"})
    public String myReturnOrder(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        Integer pageNo = URLHelper.getPageNo((HttpServletRequest)request);
        Pagination pagination = this.manager.getPageForOrderReturn(member.getId(), pageNo, 10);
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("historyProductIds", (Object)this.getHistoryProductIds(request));
        ShopFrontHelper.setCommonData(request, model, web, 1);
        ShopFrontHelper.setDynamicPageData(request, model, web, "", "myReturnOrder", ".jspx", pageNo);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)MY_RETURN_ORDER, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/order/shipments.jspx"})
    public String shipments(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        WebErrors errors = this.validateOrderReturnView(id, member, request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        OrderReturn entity = this.orderReturnMng.findById(id);
        entity.setStatus(4);
        this.orderReturnMng.update(entity);
        return this.myReturnOrder(request, model);
    }

    @RequestMapping(value={"/order/accomplish.jspx"})
    public String accomplish(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        WebErrors errors = this.validateOrderReturnView(id, member, request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        OrderReturn entity = this.orderReturnMng.findById(id);
        entity.setStatus(7);
        Set<OrderItem> set = entity.getOrder().getItems();
        for (OrderItem item : set) {
            Product product = item.getProduct();
            if (item.getProductFash() != null) {
                ProductFashion fashion = item.getProductFash();
                fashion.setStockCount(fashion.getStockCount() + item.getCount());
                product.setStockCount(product.getStockCount() + item.getCount());
                this.productFashionMng.update(fashion);
            } else {
                product.setStockCount(product.getStockCount() + item.getCount());
            }
            this.productMng.updateByUpdater(product);
        }
        member.setFreezeScore(member.getFreezeScore() - entity.getOrder().getScore());
        this.shopMemberMng.update(member);
        List<ShopScore> list = this.shopScoreMng.getlist(Long.toString(entity.getOrder().getCode()));
        for (ShopScore s : list) {
            this.shopScoreMng.deleteById(s.getId());
        }
        this.orderReturnMng.update(entity);
        return this.myReturnOrder(request, model);
    }

    private WebErrors validateOrderView(Long orderId, ShopMember member, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifNull((Object)orderId, "orderId")) {
            return errors;
        }
        Order order = this.manager.findById(orderId);
        if (errors.ifNotExist((Object)order, Order.class, (Serializable)orderId)) {
            return errors;
        }
        if (!order.getMember().getId().equals(member.getId())) {
            errors.noPermission(Order.class, (Serializable)orderId);
            return errors;
        }
        return errors;
    }

    public String getHistoryProductIds(HttpServletRequest request) {
        String str = null;
        Cookie[] cookie = request.getCookies();
        int num = cookie.length;
        int i = 0;
        while (i < num) {
            if (cookie[i].getName().equals("shop_record")) {
                str = cookie[i].getValue();
                break;
            }
            ++i;
        }
        return str;
    }

    private WebErrors validateOrderReturnView(Long orderReturnId, ShopMember member, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifNull((Object)orderReturnId, "orderReturnId")) {
            return errors;
        }
        OrderReturn orderReturn = this.orderReturnMng.findById(orderReturnId);
        if (errors.ifNotExist((Object)orderReturn, OrderReturn.class, (Serializable)orderReturnId)) {
            return errors;
        }
        if (!orderReturn.getOrder().getMember().getId().equals(member.getId())) {
            errors.noPermission(OrderReturn.class, (Serializable)orderReturnId);
            return errors;
        }
        return errors;
    }
}

