/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.front;

import com.jspgou.cms.entity.Order;
import com.jspgou.cms.entity.OrderReturn;
import com.jspgou.cms.entity.ShopDictionary;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.manager.OrderMng;
import com.jspgou.cms.manager.OrderReturnMng;
import com.jspgou.cms.manager.ShopDictionaryMng;
import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.security.annotation.Secured;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import com.jspgou.core.web.front.FrontHelper;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Secured
@Controller
public class OrderReturnAct {
    private static final Logger log = LoggerFactory.getLogger(OrderReturnAct.class);
    private static final String NODELIVERY_ORDER_RETURN = "tpl.noDeliveryOrderReturn";
    private static final String DELIVERYED_ORDER_RETURN = "tpl.DeliveryedOrderReturn";
    private static final String NODELIVERY_RETURN_MONEY_SUCCESS = "tpl.NoDeliveryedReturnMoneySuccess";
    private static final String DELIVERY_RETURN_MONEY_SUCCESS = "tpl.DeliveryedReturnMoneySuccess";
    @Autowired
    private OrderMng orderMng;
    @Autowired
    private OrderReturnMng manager;
    @Autowired
    private ShopDictionaryMng shopDictionaryMng;

    @RequestMapping(value={"/orderReturn/orderReturn.jspx"})
    public String getOrderReturn(Long orderId, Boolean delivery, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        WebErrors errors = this.validateOrderView(orderId, member, request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        Order order = this.orderMng.findById(orderId);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        List<ShopDictionary> ndList = null;
        List<ShopDictionary> returnList = this.shopDictionaryMng.getListByType(9L);
        model.addAttribute("returnList", returnList);
        model.addAttribute("order", (Object)order);
        model.addAttribute("delivery", (Object)delivery);
        if (delivery.booleanValue()) {
            ndList = this.shopDictionaryMng.getListByType(8L);
            model.addAttribute("ndList", ndList);
            return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)DELIVERYED_ORDER_RETURN, (Object[])new Object[0]));
        }
        ndList = this.shopDictionaryMng.getListByType(6L);
        model.addAttribute("ndList", ndList);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)NODELIVERY_ORDER_RETURN, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/orderReturn/orderReturnRefer.jspx"}, method={RequestMethod.POST})
    public String getOrderReturnRefer(OrderReturn bean, Long orderId, Boolean delivery, Long reasonId, String[] picPaths, String[] picDescs, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        WebErrors errors = this.validateOrderView(orderId, member, request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        Order order = this.orderMng.findById(orderId);
        OrderReturn orderReturn = this.manager.save(bean, order, reasonId, delivery, picPaths, picDescs);
        log.debug("orderReturn createTime is: {}", (Object)orderReturn.getCreateTime());
        order.setReturnOrder(orderReturn);
        this.orderMng.updateByUpdater(order);
        model.addAttribute("order", (Object)order);
        model.addAttribute("orderReturn", (Object)orderReturn);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        if (delivery.booleanValue()) {
            return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)DELIVERY_RETURN_MONEY_SUCCESS, (Object[])new Object[0]));
        }
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)NODELIVERY_RETURN_MONEY_SUCCESS, (Object[])new Object[0]));
    }

    private WebErrors validateOrderView(Long orderId, ShopMember member, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifNull((Object)orderId, "orderId")) {
            return errors;
        }
        Order order = this.orderMng.findById(orderId);
        if (errors.ifNotExist((Object)order, Order.class, (Serializable)orderId)) {
            return errors;
        }
        if (!order.getMember().getId().equals(member.getId())) {
            errors.noPermission(Order.class, (Serializable)orderId);
            return errors;
        }
        return errors;
    }
}

