/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.front;

import com.jspgou.cms.entity.Consult;
import com.jspgou.cms.entity.Discuss;
import com.jspgou.cms.entity.OrderItem;
import com.jspgou.cms.entity.Product;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.manager.ConsultMng;
import com.jspgou.cms.manager.DiscussMng;
import com.jspgou.cms.manager.OrderItemMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.front.FrontHelper;
import com.jspgou.core.web.front.URLHelper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ProductFormAct {
    @Autowired
    private ProductMng productMng;
    @Autowired
    private ConsultMng consultMng;
    @Autowired
    private OrderItemMng orderItemMng;
    @Autowired
    private DiscussMng discussMng;

    @RequestMapping(value={"/searchDiscussPage*.jspx"})
    public String searchDiscussPage(Long productId, Integer pageNo, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (productId == null || this.productMng.findById(productId) == null) {
            return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        Product bean = this.productMng.findById(productId);
        model.addAttribute("product", (Object)bean);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        ShopFrontHelper.setDynamicPageData(request, model, web, "", "searchDiscussPage", ".jspx", SimplePage.cpn((Integer)pageNo));
        return web.getTemplate("shop", MessageResolver.getMessage((HttpServletRequest)request, (String)"tpl.discussContentPage", (Object[])new Object[0]));
    }

    @RequestMapping(value={"/haveDiscuss*.jspx"})
    public String haveDiscuss(Long productId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"denru");
            return null;
        }
        if (productId == null || this.productMng.findById(productId) == null) {
            return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        OrderItem bean = this.orderItemMng.findByMember(member.getId(), productId);
        if (bean != null) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"success");
            return null;
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
        return null;
    }

    @RequestMapping(value={"/consultProduct*.jspx"})
    public String consultProduct(Long productId, Integer pageNo, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (productId == null || this.productMng.findById(productId) == null) {
            return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        ShopFrontHelper.setCommonData(request, model, web, SimplePage.cpn((Integer)pageNo));
        Product bean = this.productMng.findById(productId);
        Pagination page = this.consultMng.getPage(productId, null, null, null, null, SimplePage.cpn((Integer)pageNo), 5, true);
        model.addAttribute("product", (Object)bean);
        model.addAttribute("pagination", (Object)page);
        ShopFrontHelper.setDynamicPageData(request, model, web, "", "consultProduct", ".jspx", SimplePage.cpn((Integer)pageNo));
        return web.getTemplate("shop", MessageResolver.getMessage((HttpServletRequest)request, (String)"tpl.consultProduct", (Object[])new Object[0]));
    }

    @RequestMapping(value={"/bargain*.jspx"})
    public String list(Long productId, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (productId == null || this.productMng.findById(productId) == null) {
            return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        int pageNo = URLHelper.getPageNo((HttpServletRequest)request);
        Product bean = this.productMng.findById(productId);
        Pagination page = this.orderItemMng.getOrderItem(SimplePage.cpn((Integer)pageNo), 4, productId);
        model.addAttribute("pagination", (Object)page);
        model.addAttribute("product", (Object)bean);
        ShopFrontHelper.setCommonData(request, model, web, pageNo);
        ShopFrontHelper.setDynamicPageData(request, model, web, RequestUtils.getLocation((HttpServletRequest)request), "bargain", ".jspx", pageNo);
        return web.getTplSys("shop", MessageResolver.getMessage((HttpServletRequest)request, (String)"tpl.bargain", (Object[])new Object[0]));
    }

    @RequestMapping(value={"/insertConsult.jspx"})
    public String insertConsult(Long productId, String content, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            return null;
        }
        if (productId == null || this.productMng.findById(productId) == null) {
            return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        Consult bean = this.consultMng.saveOrUpdate(productId, content, member.getId());
        if (bean == null) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"sameUsually");
            return null;
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)"success");
        return null;
    }

    @RequestMapping(value={"/insertDiscuss.jspx "})
    public String insertDiscuss(Long productId, String disCon, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            return null;
        }
        if (productId == null || this.productMng.findById(productId) == null) {
            return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        Discuss bean = this.discussMng.saveOrUpdate(productId, disCon, member.getId());
        if (bean == null) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"sameUsually");
            return null;
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)"success");
        return null;
    }

    @RequestMapping(value={"/historyRecord.jspx"})
    public String historyRecord(Long productId, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            return null;
        }
        if (productId == null || this.productMng.findById(productId) == null) {
            return FrontHelper.pageNotFound((Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        String str = "";
        Cookie[] cookeis = request.getCookies();
        int num = cookeis.length;
        int i = 0;
        while (i < num) {
            if (cookeis[i].getName().equals("shop_record")) {
                str = String.valueOf(',') + cookeis[i].getValue();
                break;
            }
            ++i;
        }
        str = productId + str;
        int n = 0;
        int m = 0;
        int j = str.length();
        int i2 = 0;
        while (i2 < j) {
            if (str.charAt(i2) == ',') {
                ++n;
            }
            if (n == 6) break;
            m = i2 + 1;
            ++i2;
        }
        Cookie cook = new Cookie("shop_record", str.substring(0, m));
        String path = request.getContextPath();
        cook.setPath(StringUtils.isBlank((String)path) ? "/" : path);
        response.addCookie(cook);
        return null;
    }
}

