/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.front;

import com.jspgou.cms.entity.GiftExchange;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.manager.GiftExchangeMng;
import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import com.jspgou.core.web.front.FrontHelper;
import com.jspgou.core.web.front.URLHelper;
import java.io.Serializable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShopScoreAct {
    public static final String MEMBER_SCORE = "tpl.myscore";
    @Autowired
    private GiftExchangeMng giftExchangeMng;

    @RequestMapping(value={"/shopScore/myscore*.jspx"})
    public String getMyScore(Integer status, Integer useStatus, String startTime, String endTime, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        Integer pageNo = URLHelper.getPageNo((HttpServletRequest)request);
        model.addAttribute("historyProductIds", (Object)this.getHistoryProductIds(request));
        model.addAttribute("status", (Object)status);
        model.addAttribute("useStatus", (Object)useStatus);
        model.addAttribute("startTime", (Object)startTime);
        model.addAttribute("endTime", (Object)endTime);
        model.addAttribute("historyProductIds", (Object)"");
        ShopFrontHelper.setCommonData(request, model, web, 1);
        ShopFrontHelper.setDynamicPageData(request, model, web, "", "myscore", ".jspx", pageNo);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)MEMBER_SCORE, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/shopScore/exchange.jspx"})
    public String exchange(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        model.addAttribute("list", this.giftExchangeMng.getlist(member.getId()));
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)"tpl.exchange", (Object[])new Object[0]));
    }

    @RequestMapping(value={"/shopScore/exchange_accomplish.jspx"})
    public String exchangeaccomplish(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        WebErrors errors = this.validateGiftExchangeView(id, request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        GiftExchange giftExchange = this.giftExchangeMng.findById(id);
        if (giftExchange.getMember().equals(member) && giftExchange.getStatus() == 2) {
            giftExchange.setStatus(3);
            this.giftExchangeMng.update(giftExchange);
        }
        return this.exchange(request, model);
    }

    public String getHistoryProductIds(HttpServletRequest request) {
        String str = null;
        Cookie[] cookie = request.getCookies();
        int num = cookie.length;
        int i = 0;
        while (i < num) {
            if (cookie[i].getName().equals("shop_record")) {
                str = cookie[i].getValue();
                break;
            }
            ++i;
        }
        return str;
    }

    private WebErrors validateGiftExchangeView(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifNull((Object)id, "id")) {
            return errors;
        }
        GiftExchange giftExchange = this.giftExchangeMng.findById(id);
        if (errors.ifNotExist((Object)giftExchange, GiftExchange.class, (Serializable)id)) {
            return errors;
        }
        return errors;
    }
}

