/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.front;

import com.jspgou.cms.entity.ShopAdmin;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.web.threadvariable.AdminThread;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.web.HttpRequestUtil;
import com.jspgou.common.web.LoginUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.core.entity.User;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.UserMng;
import com.jspgou.core.web.SiteUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ThirdLoginAct {
    @Autowired
    private UserMng userMng;

    @RequestMapping(value={"/sso/authenticate.jspx"})
    public void authenticate(String username, String sessionId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        User user = this.userMng.getByUsername(username);
        if (user != null && sessionId != null) {
            String userSessionId = user.getSessionId();
            if (StringUtils.isNotBlank((String)userSessionId)) {
                if (userSessionId.equals(sessionId)) {
                    ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
                }
            } else {
                ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            }
        }
    }

    @RequestMapping(value={"/sso/login.jspx"})
    public void loginSso(String username, String sessionId, String ssoLogout, HttpServletRequest request, HttpServletResponse response) {
        ShopMember member;
        User user = null;
        ShopAdmin admin = AdminThread.get();
        if (admin != null) {
            user = admin.getAdmin().getUser();
        }
        if ((member = MemberThread.get()) != null) {
            user = member.getMember().getUser();
        }
        Website site = SiteUtils.getWeb((HttpServletRequest)request);
        if (StringUtils.isNotBlank((String)username)) {
            JSONObject object = new JSONObject();
            try {
                if (user == null) {
                    List authenticateUrls = site.getSsoAuthenticateUrls();
                    String success = this.authenticate(username, sessionId, authenticateUrls);
                    if (success.equals("true")) {
                        LoginUtils.loginShiro((HttpServletRequest)request, (HttpServletResponse)response, (String)username);
                        user = this.userMng.getByUsername(username);
                        if (user != null) {
                            this.userMng.updateLoginInfo(user.getId(), null, null, sessionId);
                        }
                        object.put("result", (Object)"login");
                    }
                } else if (StringUtils.isNotBlank((String)ssoLogout) && ssoLogout.equals("true")) {
                    LoginUtils.logout();
                    object.put("result", (Object)"logout");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            ResponseUtils.renderJson((HttpServletResponse)response, (String)object.toString());
        }
    }

    private String authenticate(String username, String sessionId, List<String> authenticateUrls) {
        String result = "false";
        for (String url : authenticateUrls) {
            result = this.authenticate(username, sessionId, url);
            if (result.equals("true")) break;
        }
        return result;
    }

    private String authenticate(String username, String sessionId, String authenticateUrl) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        params.put("sessionId", sessionId);
        String success = "false";
        try {
            success = HttpRequestUtil.request((String)authenticateUrl, params, (String)"post", (String)"utf-8");
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return success;
    }
}

