/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.member;

import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.common.web.session.SessionProvider;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.EmailSender;
import com.jspgou.core.entity.MessageTemplate;
import com.jspgou.core.entity.User;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.UserMng;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import com.jspgou.core.web.front.FrontHelper;
import com.octo.captcha.service.CaptchaService;
import com.octo.captcha.service.CaptchaServiceException;
import java.io.Serializable;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ForgotPasswordAct {
    private static final Logger log = LoggerFactory.getLogger(ForgotPasswordAct.class);
    private static final String FORGOTTEN_INPUT = "tpl.forgottenInput";
    private static final String FORGOTTEN_RESULT = "tpl.forgottenResult";
    private static final String RESET_PASSWORD_TPL = "tpl.resetPassword";
    @Autowired
    private UserMng userMng;
    @Autowired
    private CaptchaService captchaService;
    @Autowired
    private SessionProvider session;

    @RequestMapping(value={"/forgot_password.jspx"}, method={RequestMethod.GET})
    public String fogottenInput(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)FORGOTTEN_INPUT, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/forgot_password.jspx"}, method={RequestMethod.POST})
    public String fogottenSubmit(String checkcode, String username, String email, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateFogotten(checkcode, username, email, request, response);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        User user = this.userMng.getByUsername(username);
        MessageTemplate tpl = (MessageTemplate)web.getMessages().get("resetPassword");
        EmailSender sender = web.getEmailSender();
        if (user == null) {
            model.addAttribute("status", (Object)1);
        } else if (!user.getEmail().equalsIgnoreCase(email)) {
            model.addAttribute("status", (Object)2);
        } else if (!user.getEmail().equals(email)) {
            model.addAttribute("status", (Object)3);
        } else if (sender == null) {
            model.addAttribute("status", (Object)4);
        } else if (tpl == null) {
            model.addAttribute("status", (Object)5);
        } else {
            try {
                String base = new String(web.getUrlBuff(true));
                user = this.userMng.passwordForgotten(user.getId(), base, sender, tpl);
                String emailtype = email.substring(email.indexOf("@") + 1, email.indexOf("."));
                model.addAttribute("emailtype", (Object)emailtype);
                model.addAttribute("status", (Object)0);
                model.addAttribute("user", (Object)user);
            }
            catch (Exception e) {
                model.addAttribute("status", (Object)100);
                model.addAttribute("message", (Object)e.getMessage());
                log.error("send email exception.", (Throwable)e);
            }
        }
        model.addAttribute("user", (Object)user);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        log.info("find passsword, username={} email={}", (Object)username, (Object)email);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)FORGOTTEN_RESULT, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/reset_password.jspx"})
    public String resetPwd(Long uid, String activationCode, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        boolean success;
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        WebErrors errors = this.validateReset(uid, activationCode, request);
        if (errors.hasErrors()) {
            return FrontHelper.showMessage((String)((String)errors.getErrors().get(0)), (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        User user = this.userMng.findById(uid);
        if (activationCode.equals(user.getResetKey())) {
            user = this.userMng.resetPassword(user.getId());
            success = true;
        } else {
            success = false;
        }
        model.addAttribute("user", (Object)user);
        model.addAttribute("success", (Object)success);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)RESET_PASSWORD_TPL, (Object[])new Object[0]));
    }

    private WebErrors validateFogotten(String checkcode, String username, String email, HttpServletRequest request, HttpServletResponse response) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        String id = this.session.getSessionId(request, response);
        if (errors.ifOutOfLength(checkcode, "checkcode", 3, 10)) {
            return errors;
        }
        try {
            if (!this.captchaService.validateResponseForID(id, (Object)checkcode.toUpperCase(Locale.ENGLISH)).booleanValue()) {
                errors.addErrorCode("error.checkcodeIncorrect");
                return errors;
            }
        }
        catch (CaptchaServiceException e) {
            errors.addErrorCode("error.checkcodeInvalid");
            errors.addErrorString(e.getMessage());
            return errors;
        }
        if (errors.ifNotEmail(email, "email", 100)) {
            return errors;
        }
        if (errors.ifNotUsername(username, "username", 3, 100)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateReset(Long uid, String resetKey, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifNull((Object)uid, "uid")) {
            return errors;
        }
        User user = this.userMng.findById(uid);
        if (errors.ifNotExist((Object)user, User.class, (Serializable)uid)) {
            return errors;
        }
        if (errors.ifOutOfLength(resetKey, "resetKey", 32, 32)) {
            return errors;
        }
        return errors;
    }
}

