/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.member;

import com.jspgou.cms.manager.ProductMng;
import com.jspgou.common.image.ImageScale;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.ServletContextAware;

@Controller
public class ImageCutAct
implements ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(ImageCutAct.class);
    public static final String IMAGE_SELECT_RESULT = "/common/image_area_select";
    public static final String IMAGE_CUTED = "/common/image_cuted";
    public static final String ERROR = "error";
    @Autowired
    private ImageScale imageScale;
    private ServletContext servletContext;
    @Autowired
    private ProductMng productMng;

    @RequestMapping(value={"/common/v_image_area_select.jspx"})
    public String imageAreaSelect(String imgSrcRoot, String imgSrcPath, Integer zoomWidth, Integer zoomHeight, Integer uploadNum, HttpServletRequest request, ModelMap model) {
        model.addAttribute("imgSrcRoot", (Object)imgSrcRoot);
        model.addAttribute("imgSrcPath", (Object)imgSrcPath);
        model.addAttribute("zoomWidth", (Object)zoomWidth);
        model.addAttribute("zoomHeight", (Object)zoomHeight);
        model.addAttribute("uploadNum", (Object)uploadNum);
        return IMAGE_SELECT_RESULT;
    }

    @RequestMapping(value={"/common/o_image_cut.jspx"})
    public String imageCut(String imgSrcPath, Integer imgTop, Integer imgLeft, Integer imgWidth, Integer imgHeight, Integer reMinWidth, Integer reMinHeight, Float imgScale, Integer uploadNum, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        String real = this.servletContext.getRealPath(web.getUploadRel(imgSrcPath));
        File srcFile = new File(real);
        try {
            if (imgWidth != null) {
                if (imgWidth > 0) {
                    this.imageScale.resizeFix(srcFile, srcFile, reMinWidth.intValue(), reMinHeight.intValue(), this.getLen(imgTop, imgScale.floatValue()), this.getLen(imgLeft, imgScale.floatValue()), this.getLen(imgWidth, imgScale.floatValue()), this.getLen(imgHeight, imgScale.floatValue()));
                } else {
                    this.imageScale.resizeFix(srcFile, srcFile, reMinWidth.intValue(), reMinHeight.intValue());
                }
            } else {
                model.addAttribute(ERROR, (Object)this.productMng.getTipFile("Picture.width.cannot.beempty"));
            }
            model.addAttribute("uploadNum", (Object)uploadNum);
        }
        catch (Exception e) {
            log.error("cut image error", (Throwable)e);
            model.addAttribute(ERROR, (Object)e.getMessage());
        }
        return IMAGE_CUTED;
    }

    private int getLen(int len, float imgScale) {
        return Math.round((float)len / imgScale);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

