/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.member;

import com.jspgou.common.file.FileNameUtils;
import com.jspgou.common.image.ImageUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ImageUploadAct
implements ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(ImageUploadAct.class);
    private static final String RESULT_PAGE = "iframe_upload";
    public static final String ERROR = "error";
    private ServletContext servletContext;

    @RequestMapping(value={"/common/o_upload_image.jspx"})
    public String execute(String fileName, Integer uploadNum, Integer zoomWidth, Integer zoomHeight, @RequestParam(value="uploadFile", required=false) MultipartFile file, HttpServletRequest request, ModelMap model) {
        String dateDir;
        WebErrors errors = this.validate(fileName, file, request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (errors.hasErrors()) {
            model.addAttribute(ERROR, errors.getErrors().get(0));
            return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)RESULT_PAGE, (Object[])new Object[0]));
        }
        String real = this.servletContext.getRealPath(web.getUploadRel());
        File root = new File(real, dateDir = FileNameUtils.genPathName());
        if (!root.exists()) {
            root.mkdirs();
        }
        if (StringUtils.isBlank((String)fileName)) {
            String ext = FilenameUtils.getExtension((String)file.getOriginalFilename());
            fileName = FileNameUtils.genFileName((String)ext);
        } else {
            fileName = FilenameUtils.getName((String)fileName);
        }
        File tempFile = new File(root, fileName);
        String ctx = request.getContextPath();
        String relPath = String.valueOf(ctx) + "/" + "u" + "/" + dateDir + "/" + fileName;
        model.addAttribute("zoomWidth", (Object)zoomWidth);
        model.addAttribute("zoomHeight", (Object)zoomHeight);
        try {
            file.transferTo(tempFile);
            model.addAttribute("uploadPath", (Object)relPath);
            model.addAttribute("uploadNum", (Object)uploadNum);
        }
        catch (IllegalStateException e) {
            model.addAttribute(ERROR, (Object)e.getMessage());
            log.error("upload file error!", (Throwable)e);
        }
        catch (IOException e) {
            model.addAttribute(ERROR, (Object)e.getMessage());
            log.error("upload file error!", (Throwable)e);
        }
        model.addAttribute("zoomWidth", (Object)zoomWidth);
        model.addAttribute("zoomHeight", (Object)zoomHeight);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)RESULT_PAGE, (Object[])new Object[0]));
    }

    private WebErrors validate(String fileName, MultipartFile file, HttpServletRequest request) {
        String ext;
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (file == null) {
            errors.addErrorCode("imageupload.error.noFileToUpload");
            return errors;
        }
        if (StringUtils.isBlank((String)fileName)) {
            fileName = file.getOriginalFilename();
        }
        if (!ImageUtils.isImage((String)(ext = FilenameUtils.getExtension((String)fileName)))) {
            errors.addErrorCode("imageupload.error.notSupportExt", new Object[]{ext});
            return errors;
        }
        return errors;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

