/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.member;

import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.service.LoginSvc;
import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.common.security.BadCredentialsException;
import com.jspgou.common.security.UserNotAcitveException;
import com.jspgou.common.security.UsernameNotFoundException;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.User;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.UserMng;
import com.jspgou.core.security.UserNotInWebsiteException;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class LoginAct {
    private static final Logger log = LoggerFactory.getLogger(LoginAct.class);
    private static final String LOGIN_INPUT = "tpl.loginInput";
    public static final String TPL_INDEX = "tpl.index";
    @Autowired
    private LoginSvc loginSvc;
    @Autowired
    private UserMng userMng;

    @RequestMapping(value={"/login.jspx"}, method={RequestMethod.GET})
    public String loginInput(String returnUrl, String message, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (!StringUtils.isBlank((String)returnUrl)) {
            model.addAttribute("returnUrl", (Object)returnUrl);
            if (!StringUtils.isBlank((String)message)) {
                model.addAttribute("message", (Object)message);
            }
        }
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)LOGIN_INPUT, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/login.jspx"}, method={RequestMethod.POST})
    public String loginSubmit(String username, String password, String returnUrl, String redirectUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        ShopMember member;
        WebErrors errors;
        Website web;
        block8: {
            web = SiteUtils.getWeb((HttpServletRequest)request);
            errors = WebErrors.create((HttpServletRequest)request);
            member = this.loginSvc.memberLogin(request, response, web, username, password);
            if (member != null) break block8;
            return "redirect:/";
        }
        try {
            log.info("member '{}' login success.", (Object)username);
            if (!StringUtils.isBlank((String)returnUrl)) {
                return "redirect:" + returnUrl;
            }
            if (!StringUtils.isBlank((String)redirectUrl)) {
                return "redirect:" + redirectUrl;
            }
            model.addAttribute("member", (Object)member);
            ShopFrontHelper.setCommonData(request, model, web, 1);
            return web.getTemplate("index", MessageResolver.getMessage((HttpServletRequest)request, (String)TPL_INDEX, (Object[])new Object[0]));
        }
        catch (UsernameNotFoundException e) {
            errors.addErrorCode("error.usernameNotExist");
            log.info(e.getMessage());
        }
        catch (BadCredentialsException e) {
            errors.addErrorCode("error.passwordInvalid");
            log.info(e.getMessage());
        }
        catch (UserNotInWebsiteException e) {
            errors.addErrorCode("error.usernameNotInWebsite");
            log.info(e.getMessage());
        }
        catch (UserNotAcitveException e) {
            errors.addErrorCode("error.usernameNotActivated");
            log.info(e.getMessage());
        }
        errors.toModel((Map)model);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)LOGIN_INPUT, (Object[])new Object[0]));
    }

    public Integer errorRemaining(String username) {
        if (StringUtils.isBlank((String)username)) {
            return null;
        }
        User user = this.userMng.getByUsername(username);
        if (user == null) {
            return null;
        }
        return null;
    }

    @RequestMapping(value={"/logout.jspx"})
    public String logout(String redirectUrl, HttpServletRequest request, HttpServletResponse response) {
        this.loginSvc.logout(request, response);
        if (!StringUtils.isBlank((String)redirectUrl)) {
            return "redirect:" + redirectUrl;
        }
        return "redirect:/";
    }
}

