/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.member;

import com.jspgou.cms.entity.ShopConfig;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.ShopScore;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.cms.manager.ShopScoreMng;
import com.jspgou.cms.manager.WebserviceMng;
import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.cms.web.SiteUtils;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.common.web.session.SessionProvider;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.EmailSender;
import com.jspgou.core.entity.Member;
import com.jspgou.core.entity.MessageTemplate;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.MemberMng;
import com.jspgou.core.manager.UserMng;
import com.jspgou.core.web.WebErrors;
import com.jspgou.core.web.front.FrontHelper;
import com.octo.captcha.service.CaptchaService;
import com.octo.captcha.service.CaptchaServiceException;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class RegisterAct {
    private static final Logger log = LoggerFactory.getLogger(RegisterAct.class);
    private static final String REGISTER = "tpl.register";
    private static final String REGISTER_RESULT = "tpl.registerResult";
    private static final String REGISTER_TREATY = "tpl.registerTreaty";
    private static final String REGISTER_ACTIVE_STATUS = "tpl.registerActiveStatus";
    @Autowired
    private UserMng userMng;
    @Autowired
    private ShopMemberMng shopMemberMng;
    @Autowired
    private ShopScoreMng shopScoreMng;
    @Autowired
    private MemberMng memberMng;
    @Autowired
    private CaptchaService captchaService;
    @Autowired
    private SessionProvider session;
    @Autowired
    private WebserviceMng webserviceMng;

    @RequestMapping(value={"/register.jspx"}, method={RequestMethod.GET})
    public String registerInput(HttpServletRequest request, ModelMap model) {
        Website web = com.jspgou.core.web.SiteUtils.getWeb((HttpServletRequest)request);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)REGISTER, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/register.jspx"}, method={RequestMethod.POST})
    public String registerSubmit(String checkcode, String username, String email, String password, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = com.jspgou.core.web.SiteUtils.getWeb((HttpServletRequest)request);
        ShopConfig config = SiteUtils.getConfig(request);
        WebErrors errors = this.validate(checkcode, username, email, password, request, response);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        ShopFrontHelper.setCommonData(request, model, web, 1);
        EmailSender sender = web.getEmailSender();
        MessageTemplate tpl = (MessageTemplate)web.getMessages().get("resetPassword");
        if (sender == null) {
            model.addAttribute("status", (Object)2);
        } else if (tpl == null) {
            model.addAttribute("status", (Object)3);
        } else {
            try {
                String uuid = StringUtils.remove((String)UUID.randomUUID().toString(), (char)'-');
                String base = new String(web.getUrlBuff(true));
                this.userMng.senderActiveEmail(username, base, email, uuid, sender, tpl);
                ShopMember member = this.shopMemberMng.register(username, password, email, false, uuid, request.getRemoteAddr(), false, web.getId(), config.getRegisterGroup().getId());
                this.webserviceMng.callWebService("false", username, password, email, null, "addUser");
                String emailtype = email.substring(email.indexOf("@") + 1, email.indexOf("."));
                model.addAttribute("emailtype", (Object)emailtype);
                model.addAttribute("member", (Object)member);
                model.addAttribute("status", (Object)1);
                log.info("register member '{}'", (Object)member.getUsername());
            }
            catch (Exception e) {
                model.addAttribute("status", (Object)4);
                model.addAttribute("message", (Object)e.getMessage());
                log.error("send email exception {}.", (Object)e.getMessage());
            }
        }
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)REGISTER_RESULT, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/active.jspx"}, method={RequestMethod.GET})
    public String active(String userName, String activationCode, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IOException {
        Website web = com.jspgou.core.web.SiteUtils.getWeb((HttpServletRequest)request);
        Member bean = this.memberMng.getByUsername(web.getId(), userName);
        long l = System.currentTimeMillis();
        Date date = new Date();
        date.setTime(l -= 86400000L);
        if (StringUtils.isBlank((String)String.valueOf(userName)) || StringUtils.isBlank((String)activationCode)) {
            model.addAttribute("status", (Object)2);
        } else if (bean == null) {
            model.addAttribute("status", (Object)3);
        } else if (bean.getActive().booleanValue()) {
            model.addAttribute("status", (Object)4);
        } else if (!bean.getActivationCode().equals(activationCode)) {
            model.addAttribute("status", (Object)5);
        } else if (bean.getCreateTime().compareTo(date) < 0) {
            model.addAttribute("status", (Object)6);
        } else {
            bean.setActive(Boolean.valueOf(true));
            this.memberMng.update(bean);
            this.shopMemberMng.updateScore(this.shopMemberMng.findById(bean.getId()), com.jspgou.core.web.SiteUtils.getWeb((HttpServletRequest)request).getGlobal().getActiveScore());
            ShopScore shopScore = new ShopScore();
            shopScore.setMember(this.shopMemberMng.findById(bean.getId()));
            shopScore.setName("\u90ae\u7bb1\u9a8c\u8bc1\u9001\u79ef\u5206");
            shopScore.setScoreTime(new Date());
            shopScore.setStatus(true);
            shopScore.setUseStatus(false);
            shopScore.setScoreType(ShopScore.ScoreTypes.EMAIL_VALIDATE.getValue());
            this.shopScoreMng.save(shopScore);
            model.addAttribute("status", (Object)1);
            model.addAttribute("member", (Object)bean);
        }
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)REGISTER_ACTIVE_STATUS, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/reactive.jspx"}, method={RequestMethod.POST})
    public void reactive(Long userId, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IOException {
        Website web = com.jspgou.core.web.SiteUtils.getWeb((HttpServletRequest)request);
        JSONObject json = new JSONObject();
        Member bean = this.memberMng.findById(userId);
        if (bean.getActive().booleanValue()) {
            try {
                json.put("data", 1);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            String uuid = StringUtils.remove((String)UUID.randomUUID().toString(), (char)'-');
            bean.setActivationCode(uuid);
            bean.setCreateTime(new Date());
            this.memberMng.update(bean);
            String base = new String(web.getUrlBuff(true));
            EmailSender sender = web.getEmailSender();
            Map messages = web.getMessages();
            MessageTemplate tpl = (MessageTemplate)messages.get("resetPassword");
            try {
                this.userMng.senderActiveEmail(bean.getUsername(), base, bean.getEmail(), uuid, sender, tpl);
                try {
                    json.put("data", 2);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                try {
                    json.put("data", 3);
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
            }
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/treaty.jspx"})
    public String treaty(HttpServletRequest request, ModelMap model) {
        Website web = com.jspgou.core.web.SiteUtils.getWeb((HttpServletRequest)request);
        model.addAttribute("global", (Object)com.jspgou.core.web.SiteUtils.getWeb((HttpServletRequest)request).getGlobal());
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)REGISTER_TREATY, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/username_unique.jspx"})
    public void checkUsername(HttpServletRequest request, HttpServletResponse response) {
        String username = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"username");
        if (StringUtils.isBlank((String)username)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            return;
        }
        if (this.userMng.usernameExist(username)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            return;
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
    }

    @RequestMapping(value={"/email_unique.jspx"})
    public void checkEmail(HttpServletRequest request, HttpServletResponse response) {
        String email = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"email");
        if (StringUtils.isBlank((String)email)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            return;
        }
        if (this.userMng.emailExist(email)) {
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"false");
            return;
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)"true");
    }

    private WebErrors validate(String checkcode, String username, String email, String password, HttpServletRequest request, HttpServletResponse response) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        String id = this.session.getSessionId(request, response);
        if (errors.ifOutOfLength(checkcode, "checkcode", 3, 10)) {
            return errors;
        }
        if (errors.ifOutOfLength(password, "password", 3, 32)) {
            return errors;
        }
        try {
            if (!this.captchaService.validateResponseForID(id, (Object)checkcode.toUpperCase(Locale.ENGLISH)).booleanValue()) {
                errors.addErrorCode("error.checkcodeIncorrect");
                return errors;
            }
        }
        catch (CaptchaServiceException e) {
            errors.addErrorCode("error.checkcodeInvalid");
            errors.addErrorString(e.getMessage());
            return errors;
        }
        if (errors.ifNotEmail(email, "email", 100)) {
            return errors;
        }
        if (this.userMng.emailExist(email)) {
            errors.addErrorCode("error.emailExist");
            return errors;
        }
        if (errors.ifNotUsername(username, "username", 3, 100)) {
            return errors;
        }
        if (this.userMng.usernameExist(username)) {
            errors.addErrorCode("error.usernameExist");
            return errors;
        }
        return errors;
    }
}

