/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.member;

import com.jspgou.cms.dao.OrderDao;
import com.jspgou.cms.entity.ShopDictionary;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.manager.ShopDictionaryMng;
import com.jspgou.cms.manager.ShopMemberMng;
import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.UserMng;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import com.jspgou.core.web.front.FrontHelper;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ShopMemberAct {
    private static final Logger log = LoggerFactory.getLogger(ShopMemberAct.class);
    public static final String MEMBER_CENTER = "tpl.memberCenter";
    public static final String MEMBER_PORTRAIT = "tpl.memberPortrait";
    public static final String MEMBER_PROFILE = "tpl.memberProfile";
    public static final String MEMBER_PASSWORD = "tpl.memberPassword";
    @Autowired
    private OrderDao dao;
    @Autowired
    private UserMng userMng;
    @Autowired
    private ProductMng productMng;
    @Autowired
    private ShopMemberMng manager;
    @Autowired
    private ShopDictionaryMng shopDictionaryMng;

    @RequestMapping(value={"/shopMember/index.jspx"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        BigDecimal money = this.dao.getMemberMoneyByYear(member.getId());
        Integer[] orders = this.dao.getOrderByMember(member.getId());
        Integer[] products = this.productMng.getProductByTag(web.getId());
        model.addAttribute("products", (Object)products);
        model.addAttribute("orders", (Object)orders);
        model.addAttribute("money", (Object)money);
        model.addAttribute("historyProductIds", (Object)this.getHistoryProductIds(request));
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)MEMBER_CENTER, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/shopMember/profile.jspx"}, method={RequestMethod.GET})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        List<ShopDictionary> userDegreeList = this.shopDictionaryMng.getListByType(1L);
        List<ShopDictionary> familyMembersList = this.shopDictionaryMng.getListByType(2L);
        List<ShopDictionary> incomeDescList = this.shopDictionaryMng.getListByType(3L);
        List<ShopDictionary> workSeniorityList = this.shopDictionaryMng.getListByType(4L);
        List<ShopDictionary> degreeList = this.shopDictionaryMng.getListByType(5L);
        model.addAttribute("member", (Object)member);
        model.addAttribute("userDegreeList", userDegreeList);
        model.addAttribute("familyMembersList", familyMembersList);
        model.addAttribute("incomeDescList", incomeDescList);
        model.addAttribute("workSeniorityList", workSeniorityList);
        model.addAttribute("degreeList", degreeList);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)MEMBER_PROFILE, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/shopMember/profile.jspx"}, method={RequestMethod.POST})
    public String profileSubmit(ShopMember bean, Long groupId, Long userDegreeId, Long degreeId, Long incomeDescId, Long workSeniorityId, Long familyMembersId, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        bean = this.manager.update(bean, groupId, userDegreeId, degreeId, incomeDescId, workSeniorityId, familyMembersId);
        log.info("ShopMember update infomation: {}", (Object)bean.getUsername());
        return this.index(request, response, model);
    }

    @RequestMapping(value={"/shopMember/pwd.jspx"}, method={RequestMethod.GET})
    public String passwordInput(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        ShopFrontHelper.setCommonData(request, model, web, 1);
        model.addAttribute("email", (Object)MemberThread.get().getEmail());
        model.addAttribute("historyProductIds", (Object)this.getHistoryProductIds(request));
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)MEMBER_PASSWORD, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/shopMember/portrait.jspx"}, method={RequestMethod.GET})
    public String portrait(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)MEMBER_PORTRAIT, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/shopMember/updateAvatar.jspx"}, method={RequestMethod.POST})
    public String updateAvatar(String picPaths, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        member.setAvatar(picPaths);
        this.manager.update(member);
        return "redirect: index.jspx";
    }

    @RequestMapping(value={"/shopMember/pwd.jspx"}, method={RequestMethod.POST})
    public String passwordSubmit(String origPwd, String newPwd, String email, String nextUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws IOException {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        Long userId = member.getMember().getUser().getId();
        WebErrors errors = this.validatePassword(userId, email, newPwd, member.getEmail(), origPwd, request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        this.userMng.updateUser(userId, newPwd, email);
        log.info("ShopMember update password: {}", (Object)member.getUsername());
        return FrontHelper.showSuccess((String)"global.success", (String)nextUrl, (Website)web, (ModelMap)model, (HttpServletRequest)request);
    }

    @RequestMapping(value={"/shopMember/checkPwd.jspx"})
    public void checkPwd(String origPwd, HttpServletRequest request, HttpServletResponse response) {
        ShopMember member = MemberThread.get();
        Long userId = member.getMember().getUser().getId();
        boolean pass = this.userMng.isPasswordValid(userId, origPwd);
        ResponseUtils.renderJson((HttpServletResponse)response, (String)(pass ? "true" : "false"));
    }

    public String getHistoryProductIds(HttpServletRequest request) {
        String str = null;
        Cookie[] cookie = request.getCookies();
        int num = cookie.length;
        int i = 0;
        while (i < num) {
            if (cookie[i].getName().equals("shop_record")) {
                str = cookie[i].getValue();
                break;
            }
            ++i;
        }
        return str;
    }

    private WebErrors validatePassword(Long userId, String email, String newPwd, String origEmail, String origPwd, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (!StringUtils.isBlank((String)newPwd) && errors.ifOutOfLength(newPwd, "password", 3, 32)) {
            return errors;
        }
        if (!this.userMng.isPasswordValid(userId, origPwd)) {
            errors.addErrorCode("error.passwordInvalid");
        }
        if (errors.ifNotEmail(email, "email", 100)) {
            return errors;
        }
        if (!email.equals(origEmail) && this.userMng.emailExist(email)) {
            errors.addErrorCode("error.emailExist");
            return errors;
        }
        return errors;
    }
}

