/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.member;

import com.jspgou.cms.entity.Address;
import com.jspgou.cms.entity.ShopMember;
import com.jspgou.cms.entity.ShopMemberAddress;
import com.jspgou.cms.manager.AddressMng;
import com.jspgou.cms.manager.OrderMng;
import com.jspgou.cms.manager.ShopMemberAddressMng;
import com.jspgou.cms.web.FrontUtils;
import com.jspgou.cms.web.ShopFrontHelper;
import com.jspgou.cms.web.threadvariable.MemberThread;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import com.jspgou.core.web.front.FrontHelper;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ShopMenberAddressAct {
    private static final Logger log = LoggerFactory.getLogger(ShopMenberAddressAct.class);
    private static final String MEMBER_ADDRESS = "tpl.memberAddress";
    private static final String MEMBER_ADDRESS_EDIT = "tpl.memberAddressEdit";
    @Autowired
    private OrderMng orderMng;
    @Autowired
    private AddressMng addressMng;
    @Autowired
    private ShopMemberAddressMng shopMemberAddressMng;

    @RequestMapping(value={"/shopMemberAddress/address_list.jspx"}, method={RequestMethod.GET})
    public String list(HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        List<ShopMemberAddress> list = this.shopMemberAddressMng.getList(member.getId());
        model.addAttribute("list", list);
        List<Address> plist = this.addressMng.getListById(null);
        model.addAttribute("plist", plist);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)MEMBER_ADDRESS, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/shopMemberAddress/address_save.jspx"}, method={RequestMethod.POST})
    public String save(ShopMemberAddress bean, Long provinceId, Long cityId, Long countryId, String returnUrl, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        List<ShopMemberAddress> list = this.shopMemberAddressMng.getList(member.getId());
        model.addAttribute("list", list);
        ShopMemberAddress entity = null;
        if (bean.getIsDefault()) {
            int i = 0;
            int j = list.size();
            while (i < j) {
                entity = list.get(i);
                entity.setIsDefault(false);
                this.shopMemberAddressMng.updateByUpdater(entity);
                ++i;
            }
        }
        if (provinceId == null || cityId == null || countryId == null) {
            ShopFrontHelper.setCommonData(request, model, web, 1);
            return FrontUtils.showMessage(request, model, "\u6536\u8d27\u5730\u5740\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6536\u8d27\u5730\u5740");
        }
        bean.setProvince(this.addressMng.findById(provinceId).getName());
        bean.setCity(this.addressMng.findById(cityId).getName());
        bean.setCountry(this.addressMng.findById(countryId).getName());
        bean.setProvinceId(this.addressMng.findById(provinceId).getId());
        bean.setCityId(this.addressMng.findById(cityId).getId());
        bean.setCountryId(this.addressMng.findById(countryId).getId());
        bean.setMember(member);
        this.shopMemberAddressMng.save(bean);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        log.info("ShopMemberAddress save success, id= {}", (Object)bean.getId());
        if (returnUrl != null) {
            return "redirect:" + returnUrl;
        }
        return "redirect:address_list.jspx";
    }

    @RequestMapping(value={"/shopMemberAddress/address_edit.jspx"}, method={RequestMethod.GET})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        WebErrors errors = this.validateEdit(id, member.getId(), request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        List<ShopMemberAddress> list = this.shopMemberAddressMng.getList(member.getId());
        model.addAttribute("list", list);
        ShopMemberAddress bean = this.shopMemberAddressMng.findById(id);
        model.addAttribute("bean", (Object)bean);
        List<Address> plist = this.addressMng.getListById(null);
        model.addAttribute("plist", plist);
        List<Address> clist = this.addressMng.getListById(bean.getProvinceId());
        model.addAttribute("clist", clist);
        List<Address> alist = this.addressMng.getListById(bean.getCityId());
        model.addAttribute("alist", alist);
        model.addAttribute("id", (Object)id);
        ShopFrontHelper.setCommonData(request, model, web, 1);
        return web.getTplSys("member", MessageResolver.getMessage((HttpServletRequest)request, (String)MEMBER_ADDRESS_EDIT, (Object[])new Object[0]));
    }

    @RequestMapping(value={"/shopMemberAddress/address_update.jspx"}, method={RequestMethod.POST})
    public String update(ShopMemberAddress bean, Long provinceId, Long cityId, Long countryId, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        List<ShopMemberAddress> list = this.shopMemberAddressMng.getList(member.getId());
        ShopMemberAddress entity = null;
        if (bean.getIsDefault()) {
            int i = 0;
            int j = list.size();
            while (i < j) {
                entity = list.get(i);
                entity.setIsDefault(false);
                this.shopMemberAddressMng.updateByUpdater(entity);
                ++i;
            }
        }
        if (provinceId == null || cityId == null || countryId == null) {
            ShopFrontHelper.setCommonData(request, model, web, 1);
            return FrontUtils.showMessage(request, model, "\u6536\u8d27\u5730\u5740\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6536\u8d27\u5730\u5740");
        }
        bean.setProvince(this.addressMng.findById(provinceId).getName());
        bean.setCity(this.addressMng.findById(cityId).getName());
        bean.setCountry(this.addressMng.findById(countryId).getName());
        this.shopMemberAddressMng.updateByUpdater(bean);
        log.info("ShopMemberAddress update success, id= {}", (Object)bean.getId());
        return "redirect:address_list.jspx";
    }

    @RequestMapping(value={"/shopMemberAddress/address_default.jspx"}, method={RequestMethod.GET})
    public String isDefault(Long id, String returnUrl, Integer count, HttpServletRequest request, ModelMap model) {
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        List<ShopMemberAddress> list = this.shopMemberAddressMng.getList(member.getId());
        ShopMemberAddress bean = this.shopMemberAddressMng.findById(id);
        ShopMemberAddress entity = null;
        int i = 0;
        int j = list.size();
        while (i < j) {
            entity = list.get(i);
            entity.setIsDefault(false);
            this.shopMemberAddressMng.updateByUpdater(entity);
            ++i;
        }
        bean.setIsDefault(true);
        this.shopMemberAddressMng.updateByUpdater(bean);
        log.info("ShopMemberAddress default success, id= {}", (Object)bean.getId());
        if (returnUrl != null) {
            if (count != null) {
                return "redirect:" + returnUrl + "&count=" + count;
            }
            return "redirect:" + returnUrl;
        }
        return "redirect:address_list.jspx";
    }

    @RequestMapping(value={"/shopMemberAddress/address_delete.jspx"}, method={RequestMethod.GET})
    public String delete(Long id, String returnUrl, Integer count, HttpServletRequest request, ModelMap model) {
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        ShopMember member = MemberThread.get();
        if (member == null) {
            return "redirect:../login.jspx";
        }
        WebErrors errors = this.validateDelete(id, member.getId(), request);
        if (errors.hasErrors()) {
            return FrontHelper.showError((WebErrors)errors, (Website)web, (ModelMap)model, (HttpServletRequest)request);
        }
        this.shopMemberAddressMng.deleteById(id, member.getId());
        log.info("ShopMemberAddress delete success, id= {}", (Object)id);
        if (returnUrl != null) {
            if (count != null) {
                return "redirect:" + returnUrl + "&count=" + count;
            }
            return "redirect:" + returnUrl;
        }
        return "redirect:address_list.jspx";
    }

    @RequestMapping(value={"/shopMemberAddress/findAllCity.jspx"})
    public void findAllCity(Long id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        List<Address> clist = this.addressMng.getListById(id);
        Long[] ids = new Long[clist.size()];
        String[] citys = new String[clist.size()];
        int i = 0;
        int j = clist.size();
        while (i < j) {
            Address city = clist.get(i);
            ids[i] = city.getId();
            citys[i] = city.getName();
            ++i;
        }
        JSONObject json = new JSONObject();
        try {
            json.put("ids", (Object)ids);
            json.put("citys", (Object)citys);
            json.put("success", true);
        }
        catch (JSONException e) {
            try {
                json.put("success", false);
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    @RequestMapping(value={"/shopMemberAddress/findAllCountry.jspx"})
    public void findAllArea(Long id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        List<Address> alist = this.addressMng.getListById(id);
        Long[] ids = new Long[alist.size()];
        String[] areas = new String[alist.size()];
        int i = 0;
        int j = alist.size();
        while (i < j) {
            Address area = alist.get(i);
            ids[i] = area.getId();
            areas[i] = area.getName();
            ++i;
        }
        JSONObject json = new JSONObject();
        try {
            json.put("ids", (Object)ids);
            json.put("areas", (Object)areas);
            json.put("success", true);
        }
        catch (JSONException e) {
            try {
                json.put("success", false);
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)json.toString());
    }

    private WebErrors validateEdit(Long addressId, Long memberId, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (this.vldAddress(addressId, memberId, errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long addressId, Long memberId, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (this.vldAddress(addressId, memberId, errors)) {
            return errors;
        }
        return errors;
    }

    private boolean vldAddress(Long addressId, Long memberId, WebErrors errors) {
        if (errors.ifNull((Object)addressId, "id")) {
            return true;
        }
        ShopMemberAddress address = this.shopMemberAddressMng.findById(addressId);
        if (errors.ifNotExist((Object)address, ShopMemberAddress.class, (Serializable)addressId)) {
            return true;
        }
        if (!memberId.equals(address.getMember().getId())) {
            errors.noPermission(ShopMemberAddress.class, (Serializable)addressId);
        }
        return false;
    }
}

